_cqa_text_report = {
  paths = {
    {
      hint = {
        {
          details = "Calling (and then returning from) a function prevents many compiler optimizations (like vectorization), breaks control flow (which reduces pipeline performance) and executes extra instructions to save/restore the registers used inside it, which is very expensive (dozens of cycles). Consider to inline small functions.\n - omp_get_num_threads@plt: 1 occurrences\n - omp_get_thread_num@plt: 1 occurrences\n",
          title = "CALL instructions",
          txt = "Detected function call instructions.\n",
        },
        {
          details = "These instructions generate more than one micro-operation and only one of them can be decoded during a cycle and the extra micro-operations increase pressure on execution units.\n - IDIV: 1 occurrences\n - VZEROUPPER: 2 occurrences\n",
          title = "Complex instructions",
          txt = "Detected COMPLEX INSTRUCTIONS.\n",
        },
        {
          workaround = "Use vector aligned instructions:\n 1) align your arrays on 64 bytes boundaries: replace { void *p = malloc (size); } with { void *p; posix_memalign (&p, 64, size); }.\n 2) inform your compiler that your arrays are vector aligned: if array 'foo' is 64 bytes-aligned, define a pointer 'p_foo' as __builtin_assume_aligned (foo, 64) and use it instead of 'foo' in the loop.\n",
          details = " - VMOVUPD: 14 occurrences\n",
          title = "Vector unaligned load/store instructions",
          txt = "Detected 14 optimal vector unaligned load/store instructions.\n",
        },
        {
          workaround = "Avoid mixing data with different types. In particular, check if the type of constants is the same as array elements.",
          details = " - CQTO: 1 occurrences\n",
          title = "Conversion instructions",
          txt = "Detected expensive conversion instructions.",
        },
        {
          title = "Type of elements and instruction set",
          txt = "10 SSE or AVX instructions are processing arithmetic or math operations on double precision FP elements in scalar mode (one at a time).\n1 AVX instructions are processing arithmetic or math operations on double precision FP elements in vector mode (four at a time).\n7 AVX-512 instructions are processing arithmetic or math operations on double precision FP elements in vector mode (eight at a time).\n",
        },
        {
          title = "Matching between your function (in the source code) and the binary function",
          txt = "The binary function is composed of 140 FP arithmetical operations:\n - 70: addition or subtraction (all inside FMA instructions)\n - 70: multiply (all inside FMA instructions)\nThe binary function is loading 1152 bytes (144 double precision FP elements).\nThe binary function is storing 560 bytes (70 double precision FP elements).",
        },
        {
          title = "Arithmetic intensity",
          txt = "Arithmetic intensity is 0.08 FP operations per loaded or stored byte.",
        },
      },
      expert = {
        {
          title = "General properties",
          txt = "nb instructions    : 209\nnb uops            : 273\nloop length        : 881\nused x86 registers : 14\nused mmx registers : 0\nused xmm registers : 11\nused ymm registers : 2\nused zmm registers : 8\nnb stack references: 1\n",
        },
        {
          title = "Front-end",
          txt = "MACRO FUSION NOT POSSIBLE\nFIT IN UOP CACHE\nmicro-operation queue: 72.00 cycles\nfront end            : 72.00 cycles\n",
        },
        {
          title = "Back-end",
          txt = "       | P0    | P1    | P2    | P3    | P4    | P5    | P6    | P7\n----------------------------------------------------------------------\nuops   | 47.00 | 47.00 | 26.33 | 26.33 | 24.00 | 47.00 | 47.00 | 26.33\ncycles | 47.00 | 47.00 | 26.33 | 26.33 | 24.00 | 47.00 | 47.00 | 26.33\n\nCycles executing div or sqrt instructions: 24.00-90.00\n",
        },
        {
          title = "Front-end and detailed OoO resources (UFS)",
          txt = "FE+BE cycles: 56.96-99.56\nStall cycles: 0.00-42.51\n",
        },
        {
          title = "Cycles summary",
          txt = "Front-end : 72.00\nDispatch  : 47.00\nDIV/SQRT  : 24.00-90.00\nOverall L1: 72.00-90.00\n",
        },
        {
          title = "Vectorization ratios",
          txt = "INT\nall    : 7%\nload   : NA (no load vectorizable/vectorized instructions)\nstore  : NA (no store vectorizable/vectorized instructions)\nmul    : NA (no mul vectorizable/vectorized instructions)\nadd-sub: NA (no add-sub vectorizable/vectorized instructions)\nfma    : NA (no fma vectorizable/vectorized instructions)\nother  : 7%\nFP\nall     : 42%\nload    : 43%\nstore   : 44%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : NA (no add-sub vectorizable/vectorized instructions)\nfma     : 44%\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 0%\nINT+FP\nall     : 30%\nload    : 43%\nstore   : 44%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : NA (no add-sub vectorizable/vectorized instructions)\nfma     : 44%\ndiv/sqrt: 0%\nother   : 6%\n",
        },
        {
          title = "Vector efficiency ratios",
          txt = "INT\nall    : 13%\nload   : NA (no load vectorizable/vectorized instructions)\nstore  : NA (no store vectorizable/vectorized instructions)\nmul    : NA (no mul vectorizable/vectorized instructions)\nadd-sub: NA (no add-sub vectorizable/vectorized instructions)\nfma    : NA (no fma vectorizable/vectorized instructions)\nother  : 13%\nFP\nall     : 46%\nload    : 47%\nstore   : 48%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : NA (no add-sub vectorizable/vectorized instructions)\nfma     : 48%\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 12%\nINT+FP\nall     : 35%\nload    : 47%\nstore   : 48%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : NA (no add-sub vectorizable/vectorized instructions)\nfma     : 48%\ndiv/sqrt: 12%\nother   : 13%\n",
        },
        {
          title = "Cycles and memory resources usage",
          txt = "Assuming all data fit into the L1 cache, each call to the function takes 90.00 cycles. At this rate:\n - 10% of peak load performance is reached (12.80 out of 128.00 bytes loaded per cycle (GB/s @ 1GHz))\n - 9% of peak store performance is reached (6.22 out of 64.00 bytes stored per cycle (GB/s @ 1GHz))\n",
        },
        {
          title = "Front-end bottlenecks",
          txt = "Found no such bottlenecks.",
        },
        {
          title = "ASM code",
          txt = "In the binary file, the address of the function is: 5a8380\n\nInstruction                                      | Nb FU | P0    | P1    | P2   | P3   | P4 | P5    | P6    | P7   | Latency | Recip. throughput\n------------------------------------------------------------------------------------------------------------------------------------------------\nPUSH %RBP                                        | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nMOV %RSP,%RBP                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nPUSH %R13                                        | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nPUSH %R12                                        | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nMOV %RDI,%R12                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nPUSH %RBX                                        | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nAND $-0x40,%RSP                                  | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nCALL 40f0b0 <omp_get_num_threads@plt>            | 2     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 1     | 0.33 | 0       | 1\nMOV %EAX,%EBX                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nCALL 40f1f0 <omp_get_thread_num@plt>             | 2     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 1     | 0.33 | 0       | 1\nMOVSXD %EBX,%RSI                                 | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nMOVSXD %EAX,%RCX                                 | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nMOV 0x18(%R12),%RAX                              | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nCQTO                                             | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 1       | 0.50\nIDIV %RSI                                        | 57    | 14.25 | 14.25 | 0    | 0    | 0  | 14.25 | 14.25 | 0    | 42-95   | 24-90\nCMP %RDX,%RCX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJL 5a8810 <hypre_SeqVectorAxpy._omp_fn.0+0x490>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nIMUL %RAX,%RCX                                   | 1     | 0     | 1     | 0    | 0    | 0  | 0     | 0     | 0    | 3       | 1\nADD %RCX,%RDX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nLEA (%RAX,%RDX,1),%R10                           | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nCMP %R10,%RDX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJGE 5a8571 <hypre_SeqVectorAxpy._omp_fn.0+0x1f1> | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nLEA -0x1(%RAX),%RSI                              | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nMOV 0x10(%R12),%RCX                              | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nMOV 0x8(%R12),%RDI                               | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nMOV %RAX,%R11                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nVMOVSD (%R12),%XMM0                              | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nMOV %RDX,%R12                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nCMP $0x2,%RSI                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJBE 5a840a <hypre_SeqVectorAxpy._omp_fn.0+0x8a>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nLEA (,%RDX,8),%R9                                | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nLEA (%RCX,%R9,1),%R8                             | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nLEA 0x8(%RDI,%R9,1),%R13                         | 1     | 0     | 1     | 0    | 0    | 0  | 0     | 0     | 0    | 3       | 1\nMOV %R8,%RBX                                     | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nSUB %R13,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nCMP $0x30,%RBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJA 5a8580 <hypre_SeqVectorAxpy._omp_fn.0+0x200>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nMOV %R10,%RBX                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nSUB %RDX,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nAND $0x7,%EBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a84cf <hypre_SeqVectorAxpy._omp_fn.0+0x14f>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x1,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a84b3 <hypre_SeqVectorAxpy._omp_fn.0+0x133>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x2,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a84a0 <hypre_SeqVectorAxpy._omp_fn.0+0x120>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x3,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a848d <hypre_SeqVectorAxpy._omp_fn.0+0x10d>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x4,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a847a <hypre_SeqVectorAxpy._omp_fn.0+0xfa>   | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x5,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8467 <hypre_SeqVectorAxpy._omp_fn.0+0xe7>   | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x6,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8454 <hypre_SeqVectorAxpy._omp_fn.0+0xd4>   | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nVMOVSD (%RDI,%RDX,8),%XMM7                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD213SD (%RCX,%RDX,8),%XMM0,%XMM7            | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM7,(%RCX,%RDX,8)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nINC %RDX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVSD (%RDI,%RDX,8),%XMM8                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD213SD (%RCX,%RDX,8),%XMM0,%XMM8            | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM8,(%RCX,%RDX,8)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nINC %RDX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVSD (%RDI,%RDX,8),%XMM9                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD213SD (%RCX,%RDX,8),%XMM0,%XMM9            | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM9,(%RCX,%RDX,8)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nINC %RDX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVSD (%RDI,%RDX,8),%XMM10                      | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD213SD (%RCX,%RDX,8),%XMM0,%XMM10           | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM10,(%RCX,%RDX,8)                      | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nINC %RDX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVSD (%RDI,%RDX,8),%XMM11                      | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD213SD (%RCX,%RDX,8),%XMM0,%XMM11           | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM11,(%RCX,%RDX,8)                      | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nINC %RDX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVSD (%RDI,%RDX,8),%XMM12                      | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD213SD (%RCX,%RDX,8),%XMM0,%XMM12           | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM12,(%RCX,%RDX,8)                      | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nINC %RDX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVSD (%RDI,%RDX,8),%XMM13                      | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD213SD (%RCX,%RDX,8),%XMM0,%XMM13           | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM13,(%RCX,%RDX,8)                      | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nINC %RDX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nCMP %RDX,%R10                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8571 <hypre_SeqVectorAxpy._omp_fn.0+0x1f1>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nLEA -0x18(%RBP),%RSP                             | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nPOP %RBX                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %R12                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %R13                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %RBP                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nRET                                              | 1     | 0     | 0     | 0.33 | 0.33 | 0  | 0     | 1     | 0.33 | 0       | 1\nNOPL (%RAX)                                      | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nCMP $0x6,%RSI                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJBE 5a884a <hypre_SeqVectorAxpy._omp_fn.0+0x4ca> | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nMOV %RAX,%R13                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nADD %RDI,%R9                                     | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVBROADCASTSD %XMM0,%ZMM1                         | 1     | 0     | 0     | 0    | 0    | 0  | 1     | 0     | 0    | 3       | 1\nXOR %EBX,%EBX                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nSHR $0x3,%R13                                    | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 1       | 0.50\nSAL $0x6,%R13                                    | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 1       | 0.50\nLEA -0x40(%R13),%R11                             | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nSHR $0x6,%R11                                    | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 1       | 0.50\nINC %R11                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nAND $0x7,%R11D                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8684 <hypre_SeqVectorAxpy._omp_fn.0+0x304>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x1,%R11                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8662 <hypre_SeqVectorAxpy._omp_fn.0+0x2e2>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x2,%R11                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8649 <hypre_SeqVectorAxpy._omp_fn.0+0x2c9>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x3,%R11                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8630 <hypre_SeqVectorAxpy._omp_fn.0+0x2b0>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x4,%R11                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8617 <hypre_SeqVectorAxpy._omp_fn.0+0x297>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x5,%R11                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a85fe <hypre_SeqVectorAxpy._omp_fn.0+0x27e>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x6,%R11                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJNE 5a882e <hypre_SeqVectorAxpy._omp_fn.0+0x4ae> | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nVMOVUPD (%R9,%RBX,1),%ZMM3                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nVFMADD213PD (%R8,%RBX,1),%ZMM1,%ZMM3             | 1     | 0.50  | 0     | 0.50 | 0.50 | 0  | 0.50  | 0     | 0    | 4       | 0.50\nVMOVUPD %ZMM3,(%R8,%RBX,1)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nADD $0x40,%RBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVUPD (%R9,%RBX,1),%ZMM4                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nVFMADD213PD (%R8,%RBX,1),%ZMM1,%ZMM4             | 1     | 0.50  | 0     | 0.50 | 0.50 | 0  | 0.50  | 0     | 0    | 4       | 0.50\nVMOVUPD %ZMM4,(%R8,%RBX,1)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nADD $0x40,%RBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVUPD (%R9,%RBX,1),%ZMM5                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nVFMADD213PD (%R8,%RBX,1),%ZMM1,%ZMM5             | 1     | 0.50  | 0     | 0.50 | 0.50 | 0  | 0.50  | 0     | 0    | 4       | 0.50\nVMOVUPD %ZMM5,(%R8,%RBX,1)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nADD $0x40,%RBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVUPD (%R9,%RBX,1),%ZMM6                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nVFMADD213PD (%R8,%RBX,1),%ZMM1,%ZMM6             | 1     | 0.50  | 0     | 0.50 | 0.50 | 0  | 0.50  | 0     | 0    | 4       | 0.50\nVMOVUPD %ZMM6,(%R8,%RBX,1)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nADD $0x40,%RBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVUPD (%R9,%RBX,1),%ZMM7                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nVFMADD213PD (%R8,%RBX,1),%ZMM1,%ZMM7             | 1     | 0.50  | 0     | 0.50 | 0.50 | 0  | 0.50  | 0     | 0    | 4       | 0.50\nVMOVUPD %ZMM7,(%R8,%RBX,1)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nADD $0x40,%RBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVUPD (%R9,%RBX,1),%ZMM8                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nVFMADD213PD (%R8,%RBX,1),%ZMM1,%ZMM8             | 1     | 0.50  | 0     | 0.50 | 0.50 | 0  | 0.50  | 0     | 0    | 4       | 0.50\nVMOVUPD %ZMM8,(%R8,%RBX,1)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nADD $0x40,%RBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nCMP %R13,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8751 <hypre_SeqVectorAxpy._omp_fn.0+0x3d1>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nMOV %RAX,%RSI                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nAND $-0x8,%RSI                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nADD %RSI,%RDX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nCMP %RSI,%RAX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8820 <hypre_SeqVectorAxpy._omp_fn.0+0x4a0>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nSUB %RSI,%RAX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nMOV %RAX,%R11                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nLEA -0x1(%RAX),%RAX                              | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nCMP $0x2,%RAX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJBE 5a87a2 <hypre_SeqVectorAxpy._omp_fn.0+0x422> | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nADD %R12,%RSI                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVBROADCASTSD %XMM0,%YMM1                         | 1     | 0     | 0     | 0    | 0    | 0  | 1     | 0     | 0    | 3       | 1\nMOV %R11,%R9                                     | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nLEA (%RCX,%RSI,8),%R12                           | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nAND $-0x4,%R9                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVUPD (%R12),%YMM3                             | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nADD %R9,%RDX                                     | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nAND $0x3,%R11D                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVFMADD132PD (%RDI,%RSI,8),%YMM3,%YMM1            | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVUPD %YMM1,(%R12)                             | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nJE 5a8820 <hypre_SeqVectorAxpy._omp_fn.0+0x4a0>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nVMOVSD (%RDI,%RDX,8),%XMM4                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nLEA (,%RDX,8),%R8                                | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nLEA 0x1(%RDX),%R13                               | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nLEA (%RCX,%R8,1),%RSI                            | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nVFMADD213SD (%RSI),%XMM0,%XMM4                   | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM4,(%RSI)                              | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nCMP %R13,%R10                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJLE 5a8820 <hypre_SeqVectorAxpy._omp_fn.0+0x4a0> | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nVMOVSD 0x8(%RDI,%R8,1),%XMM5                     | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nLEA 0x8(%RCX,%R8,1),%R11                         | 1     | 0     | 1     | 0    | 0    | 0  | 0     | 0     | 0    | 3       | 1\nADD $0x2,%RDX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVFMADD213SD (%R11),%XMM0,%XMM5                   | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM5,(%R11)                              | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nCMP %RDX,%R10                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJLE 5a8820 <hypre_SeqVectorAxpy._omp_fn.0+0x4a0> | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nLEA 0x10(%RCX,%R8,1),%RDX                        | 1     | 0     | 1     | 0    | 0    | 0  | 0     | 0     | 0    | 3       | 1\nVMOVSD (%RDX),%XMM6                              | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD132SD 0x10(%RDI,%R8,1),%XMM6,%XMM0         | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM0,(%RDX)                              | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nVZEROUPPER                                       | 4     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 1\nLEA -0x18(%RBP),%RSP                             | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nPOP %RBX                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %R12                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %R13                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %RBP                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nRET                                              | 1     | 0     | 0     | 0.33 | 0.33 | 0  | 0     | 1     | 0.33 | 0       | 1\nNOPW %CS:(%RAX,%RAX,1)                           | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nINC %RAX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nXOR %EDX,%EDX                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nJMP 5a83b5 <hypre_SeqVectorAxpy._omp_fn.0+0x35>  | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 1     | 0    | 0       | 1-2\nNOPW (%RAX,%RAX,1)                               | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nVZEROUPPER                                       | 4     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 1\nLEA -0x18(%RBP),%RSP                             | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nPOP %RBX                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %R12                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %R13                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %RBP                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nRET                                              | 1     | 0     | 0     | 0.33 | 0.33 | 0  | 0     | 1     | 0.33 | 0       | 1\nVMOVUPD (%R9),%ZMM2                              | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nMOV $0x40,%EBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVFMADD213PD (%R8),%ZMM1,%ZMM2                    | 1     | 0.50  | 0     | 0.50 | 0.50 | 0  | 0.50  | 0     | 0    | 4       | 0.50\nVMOVUPD %ZMM2,(%R8)                              | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nJMP 5a85e5 <hypre_SeqVectorAxpy._omp_fn.0+0x265> | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 1     | 0    | 0       | 1-2\nXOR %ESI,%ESI                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nJMP 5a8774 <hypre_SeqVectorAxpy._omp_fn.0+0x3f4> | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 1     | 0    | 0       | 1-2\nNOPW %CS:(%RAX,%RAX,1)                           | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nNOPL (%RAX)                                      | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\n",
        },
      },
      header = {
        "Warnings:\nDetected a function call instruction: ignoring called function instructions.\nRerun with --follow-calls=append to include them to analysis  or with --follow-calls=inline to simulate inlining.",
        "4% of peak computational performance is used (1.56 out of 32.00 FLOP per cycle (GFLOPS @ 1GHz))",
      },
      brief = {
      },
      gain = {
        {
          workaround = " - Try to reorganize arrays of structures to structures of arrays\n - Consider to permute loops (see vectorization gain report)\n",
          title = "Code clean check",
          txt = "Detected a slowdown caused by scalar integer instructions (typically used for address computation).\nBy removing them, you can lower the cost of an iteration from 90.00 to 28.00 cycles (3.21x speedup).",
        },
        {
          workaround = " - Try another compiler or update/tune your current one\n - Make array accesses unit-stride:\n  * If your function streams arrays of structures (AoS), try to use structures of arrays instead (SoA):\nfor(i) a[i].x = b[i].x; (slow, non stride 1) => for(i) a.x[i] = b.x[i]; (fast, stride 1)\n",
          details = "30% of SSE/AVX instructions are used in vector version (process two or more data elements in vector registers):\n - 43% of SSE/AVX loads are used in vector version.\n - 44% of SSE/AVX stores are used in vector version.\n - 44% of SSE/AVX fused multiply-add instructions are used in vector version.\n - 0% of SSE/AVX divide and square root instructions are used in vector version.\n - 6% of SSE/AVX instructions that are not load, store, addition, subtraction nor multiply instructions are used in vector version.\nSince your execution units are vector units, only a fully vectorized function can use their full power.\n",
          title = "Vectorization",
          txt = "Your function is poorly vectorized.\nOnly 35% of vector register length is used (average across all SSE/AVX instructions).\nBy fully vectorizing your function, you can lower the cost of an iteration from 90.00 to 53.18 cycles (1.69x speedup).",
        },
        {
          workaround = " - Reduce the number of division or square root instructions:\n  * If denominator is constant over iterations, use reciprocal (replace x/y with x*(1/y)). Check precision impact. This will be done by your compiler with ffast-math or Ofast\n - Check whether you really need double precision. If not, switch to single precision to speedup execution\n",
          title = "Execution units bottlenecks",
          txt = "Performance is limited by execution of divide and square root operations (the divide/square root unit is a bottleneck).\n\nBy removing all these bottlenecks, you can lower the cost of an iteration from 90.00 to 72.00 cycles (1.25x speedup).\n",
        },
      },
      potential = {
        {
          title = "Expensive FP math instructions/calls",
          txt = "Detected performance impact from expensive FP math instructions/calls.\nBy removing/reexpressing them, you can lower the cost of an iteration from 90.00 to 58.00 cycles (1.55x speedup).",
        },
        {
          title = "FMA",
          txt = "Detected 70 FMA (fused multiply-add) operations.",
        },
      },
    },
  },
  AVG = {
      hint = {
        {
          details = "Calling (and then returning from) a function prevents many compiler optimizations (like vectorization), breaks control flow (which reduces pipeline performance) and executes extra instructions to save/restore the registers used inside it, which is very expensive (dozens of cycles). Consider to inline small functions.\n - omp_get_num_threads@plt: 1 occurrences\n - omp_get_thread_num@plt: 1 occurrences\n",
          title = "CALL instructions",
          txt = "Detected function call instructions.\n",
        },
        {
          details = "These instructions generate more than one micro-operation and only one of them can be decoded during a cycle and the extra micro-operations increase pressure on execution units.\n - IDIV: 1 occurrences\n - VZEROUPPER: 2 occurrences\n",
          title = "Complex instructions",
          txt = "Detected COMPLEX INSTRUCTIONS.\n",
        },
        {
          workaround = "Use vector aligned instructions:\n 1) align your arrays on 64 bytes boundaries: replace { void *p = malloc (size); } with { void *p; posix_memalign (&p, 64, size); }.\n 2) inform your compiler that your arrays are vector aligned: if array 'foo' is 64 bytes-aligned, define a pointer 'p_foo' as __builtin_assume_aligned (foo, 64) and use it instead of 'foo' in the loop.\n",
          details = " - VMOVUPD: 14 occurrences\n",
          title = "Vector unaligned load/store instructions",
          txt = "Detected 14 optimal vector unaligned load/store instructions.\n",
        },
        {
          workaround = "Avoid mixing data with different types. In particular, check if the type of constants is the same as array elements.",
          details = " - CQTO: 1 occurrences\n",
          title = "Conversion instructions",
          txt = "Detected expensive conversion instructions.",
        },
        {
          title = "Type of elements and instruction set",
          txt = "10 SSE or AVX instructions are processing arithmetic or math operations on double precision FP elements in scalar mode (one at a time).\n1 AVX instructions are processing arithmetic or math operations on double precision FP elements in vector mode (four at a time).\n7 AVX-512 instructions are processing arithmetic or math operations on double precision FP elements in vector mode (eight at a time).\n",
        },
        {
          title = "Matching between your function (in the source code) and the binary function",
          txt = "The binary function is composed of 140 FP arithmetical operations:\n - 70: addition or subtraction (all inside FMA instructions)\n - 70: multiply (all inside FMA instructions)\nThe binary function is loading 1152 bytes (144 double precision FP elements).\nThe binary function is storing 560 bytes (70 double precision FP elements).",
        },
        {
          title = "Arithmetic intensity",
          txt = "Arithmetic intensity is 0.08 FP operations per loaded or stored byte.",
        },
      },
      expert = {
        {
          title = "General properties",
          txt = "nb instructions    : 209\nnb uops            : 273\nloop length        : 881\nused x86 registers : 14\nused mmx registers : 0\nused xmm registers : 11\nused ymm registers : 2\nused zmm registers : 8\nnb stack references: 1\n",
        },
        {
          title = "Front-end",
          txt = "MACRO FUSION NOT POSSIBLE\nFIT IN UOP CACHE\nmicro-operation queue: 72.00 cycles\nfront end            : 72.00 cycles\n",
        },
        {
          title = "Back-end",
          txt = "       | P0    | P1    | P2    | P3    | P4    | P5    | P6    | P7\n----------------------------------------------------------------------\nuops   | 47.00 | 47.00 | 26.33 | 26.33 | 24.00 | 47.00 | 47.00 | 26.33\ncycles | 47.00 | 47.00 | 26.33 | 26.33 | 24.00 | 47.00 | 47.00 | 26.33\n\nCycles executing div or sqrt instructions: 24.00-90.00\n",
        },
        {
          title = "Front-end and detailed OoO resources (UFS)",
          txt = "FE+BE cycles: 56.96-99.56\nStall cycles: 0.00-42.51\n",
        },
        {
          title = "Cycles summary",
          txt = "Front-end : 72.00\nDispatch  : 47.00\nDIV/SQRT  : 24.00-90.00\nOverall L1: 72.00-90.00\n",
        },
        {
          title = "Vectorization ratios",
          txt = "INT\nall    : 7%\nload   : NA (no load vectorizable/vectorized instructions)\nstore  : NA (no store vectorizable/vectorized instructions)\nmul    : NA (no mul vectorizable/vectorized instructions)\nadd-sub: NA (no add-sub vectorizable/vectorized instructions)\nfma    : NA (no fma vectorizable/vectorized instructions)\nother  : 7%\nFP\nall     : 42%\nload    : 43%\nstore   : 44%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : NA (no add-sub vectorizable/vectorized instructions)\nfma     : 44%\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 0%\nINT+FP\nall     : 30%\nload    : 43%\nstore   : 44%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : NA (no add-sub vectorizable/vectorized instructions)\nfma     : 44%\ndiv/sqrt: 0%\nother   : 6%\n",
        },
        {
          title = "Vector efficiency ratios",
          txt = "INT\nall    : 13%\nload   : NA (no load vectorizable/vectorized instructions)\nstore  : NA (no store vectorizable/vectorized instructions)\nmul    : NA (no mul vectorizable/vectorized instructions)\nadd-sub: NA (no add-sub vectorizable/vectorized instructions)\nfma    : NA (no fma vectorizable/vectorized instructions)\nother  : 13%\nFP\nall     : 46%\nload    : 47%\nstore   : 48%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : NA (no add-sub vectorizable/vectorized instructions)\nfma     : 48%\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 12%\nINT+FP\nall     : 35%\nload    : 47%\nstore   : 48%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : NA (no add-sub vectorizable/vectorized instructions)\nfma     : 48%\ndiv/sqrt: 12%\nother   : 13%\n",
        },
        {
          title = "Cycles and memory resources usage",
          txt = "Assuming all data fit into the L1 cache, each call to the function takes 90.00 cycles. At this rate:\n - 10% of peak load performance is reached (12.80 out of 128.00 bytes loaded per cycle (GB/s @ 1GHz))\n - 9% of peak store performance is reached (6.22 out of 64.00 bytes stored per cycle (GB/s @ 1GHz))\n",
        },
        {
          title = "Front-end bottlenecks",
          txt = "Found no such bottlenecks.",
        },
        {
          title = "ASM code",
          txt = "In the binary file, the address of the function is: 5a8380\n\nInstruction                                      | Nb FU | P0    | P1    | P2   | P3   | P4 | P5    | P6    | P7   | Latency | Recip. throughput\n------------------------------------------------------------------------------------------------------------------------------------------------\nPUSH %RBP                                        | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nMOV %RSP,%RBP                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nPUSH %R13                                        | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nPUSH %R12                                        | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nMOV %RDI,%R12                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nPUSH %RBX                                        | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nAND $-0x40,%RSP                                  | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nCALL 40f0b0 <omp_get_num_threads@plt>            | 2     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 1     | 0.33 | 0       | 1\nMOV %EAX,%EBX                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nCALL 40f1f0 <omp_get_thread_num@plt>             | 2     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 1     | 0.33 | 0       | 1\nMOVSXD %EBX,%RSI                                 | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nMOVSXD %EAX,%RCX                                 | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nMOV 0x18(%R12),%RAX                              | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nCQTO                                             | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 1       | 0.50\nIDIV %RSI                                        | 57    | 14.25 | 14.25 | 0    | 0    | 0  | 14.25 | 14.25 | 0    | 42-95   | 24-90\nCMP %RDX,%RCX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJL 5a8810 <hypre_SeqVectorAxpy._omp_fn.0+0x490>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nIMUL %RAX,%RCX                                   | 1     | 0     | 1     | 0    | 0    | 0  | 0     | 0     | 0    | 3       | 1\nADD %RCX,%RDX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nLEA (%RAX,%RDX,1),%R10                           | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nCMP %R10,%RDX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJGE 5a8571 <hypre_SeqVectorAxpy._omp_fn.0+0x1f1> | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nLEA -0x1(%RAX),%RSI                              | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nMOV 0x10(%R12),%RCX                              | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nMOV 0x8(%R12),%RDI                               | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nMOV %RAX,%R11                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nVMOVSD (%R12),%XMM0                              | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nMOV %RDX,%R12                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nCMP $0x2,%RSI                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJBE 5a840a <hypre_SeqVectorAxpy._omp_fn.0+0x8a>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nLEA (,%RDX,8),%R9                                | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nLEA (%RCX,%R9,1),%R8                             | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nLEA 0x8(%RDI,%R9,1),%R13                         | 1     | 0     | 1     | 0    | 0    | 0  | 0     | 0     | 0    | 3       | 1\nMOV %R8,%RBX                                     | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nSUB %R13,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nCMP $0x30,%RBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJA 5a8580 <hypre_SeqVectorAxpy._omp_fn.0+0x200>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nMOV %R10,%RBX                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nSUB %RDX,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nAND $0x7,%EBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a84cf <hypre_SeqVectorAxpy._omp_fn.0+0x14f>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x1,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a84b3 <hypre_SeqVectorAxpy._omp_fn.0+0x133>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x2,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a84a0 <hypre_SeqVectorAxpy._omp_fn.0+0x120>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x3,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a848d <hypre_SeqVectorAxpy._omp_fn.0+0x10d>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x4,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a847a <hypre_SeqVectorAxpy._omp_fn.0+0xfa>   | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x5,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8467 <hypre_SeqVectorAxpy._omp_fn.0+0xe7>   | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x6,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8454 <hypre_SeqVectorAxpy._omp_fn.0+0xd4>   | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nVMOVSD (%RDI,%RDX,8),%XMM7                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD213SD (%RCX,%RDX,8),%XMM0,%XMM7            | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM7,(%RCX,%RDX,8)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nINC %RDX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVSD (%RDI,%RDX,8),%XMM8                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD213SD (%RCX,%RDX,8),%XMM0,%XMM8            | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM8,(%RCX,%RDX,8)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nINC %RDX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVSD (%RDI,%RDX,8),%XMM9                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD213SD (%RCX,%RDX,8),%XMM0,%XMM9            | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM9,(%RCX,%RDX,8)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nINC %RDX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVSD (%RDI,%RDX,8),%XMM10                      | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD213SD (%RCX,%RDX,8),%XMM0,%XMM10           | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM10,(%RCX,%RDX,8)                      | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nINC %RDX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVSD (%RDI,%RDX,8),%XMM11                      | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD213SD (%RCX,%RDX,8),%XMM0,%XMM11           | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM11,(%RCX,%RDX,8)                      | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nINC %RDX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVSD (%RDI,%RDX,8),%XMM12                      | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD213SD (%RCX,%RDX,8),%XMM0,%XMM12           | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM12,(%RCX,%RDX,8)                      | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nINC %RDX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVSD (%RDI,%RDX,8),%XMM13                      | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD213SD (%RCX,%RDX,8),%XMM0,%XMM13           | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM13,(%RCX,%RDX,8)                      | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nINC %RDX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nCMP %RDX,%R10                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8571 <hypre_SeqVectorAxpy._omp_fn.0+0x1f1>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nLEA -0x18(%RBP),%RSP                             | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nPOP %RBX                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %R12                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %R13                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %RBP                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nRET                                              | 1     | 0     | 0     | 0.33 | 0.33 | 0  | 0     | 1     | 0.33 | 0       | 1\nNOPL (%RAX)                                      | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nCMP $0x6,%RSI                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJBE 5a884a <hypre_SeqVectorAxpy._omp_fn.0+0x4ca> | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nMOV %RAX,%R13                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nADD %RDI,%R9                                     | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVBROADCASTSD %XMM0,%ZMM1                         | 1     | 0     | 0     | 0    | 0    | 0  | 1     | 0     | 0    | 3       | 1\nXOR %EBX,%EBX                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nSHR $0x3,%R13                                    | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 1       | 0.50\nSAL $0x6,%R13                                    | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 1       | 0.50\nLEA -0x40(%R13),%R11                             | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nSHR $0x6,%R11                                    | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 1       | 0.50\nINC %R11                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nAND $0x7,%R11D                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8684 <hypre_SeqVectorAxpy._omp_fn.0+0x304>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x1,%R11                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8662 <hypre_SeqVectorAxpy._omp_fn.0+0x2e2>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x2,%R11                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8649 <hypre_SeqVectorAxpy._omp_fn.0+0x2c9>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x3,%R11                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8630 <hypre_SeqVectorAxpy._omp_fn.0+0x2b0>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x4,%R11                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8617 <hypre_SeqVectorAxpy._omp_fn.0+0x297>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x5,%R11                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a85fe <hypre_SeqVectorAxpy._omp_fn.0+0x27e>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nCMP $0x6,%R11                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJNE 5a882e <hypre_SeqVectorAxpy._omp_fn.0+0x4ae> | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nVMOVUPD (%R9,%RBX,1),%ZMM3                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nVFMADD213PD (%R8,%RBX,1),%ZMM1,%ZMM3             | 1     | 0.50  | 0     | 0.50 | 0.50 | 0  | 0.50  | 0     | 0    | 4       | 0.50\nVMOVUPD %ZMM3,(%R8,%RBX,1)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nADD $0x40,%RBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVUPD (%R9,%RBX,1),%ZMM4                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nVFMADD213PD (%R8,%RBX,1),%ZMM1,%ZMM4             | 1     | 0.50  | 0     | 0.50 | 0.50 | 0  | 0.50  | 0     | 0    | 4       | 0.50\nVMOVUPD %ZMM4,(%R8,%RBX,1)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nADD $0x40,%RBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVUPD (%R9,%RBX,1),%ZMM5                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nVFMADD213PD (%R8,%RBX,1),%ZMM1,%ZMM5             | 1     | 0.50  | 0     | 0.50 | 0.50 | 0  | 0.50  | 0     | 0    | 4       | 0.50\nVMOVUPD %ZMM5,(%R8,%RBX,1)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nADD $0x40,%RBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVUPD (%R9,%RBX,1),%ZMM6                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nVFMADD213PD (%R8,%RBX,1),%ZMM1,%ZMM6             | 1     | 0.50  | 0     | 0.50 | 0.50 | 0  | 0.50  | 0     | 0    | 4       | 0.50\nVMOVUPD %ZMM6,(%R8,%RBX,1)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nADD $0x40,%RBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVUPD (%R9,%RBX,1),%ZMM7                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nVFMADD213PD (%R8,%RBX,1),%ZMM1,%ZMM7             | 1     | 0.50  | 0     | 0.50 | 0.50 | 0  | 0.50  | 0     | 0    | 4       | 0.50\nVMOVUPD %ZMM7,(%R8,%RBX,1)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nADD $0x40,%RBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVUPD (%R9,%RBX,1),%ZMM8                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nVFMADD213PD (%R8,%RBX,1),%ZMM1,%ZMM8             | 1     | 0.50  | 0     | 0.50 | 0.50 | 0  | 0.50  | 0     | 0    | 4       | 0.50\nVMOVUPD %ZMM8,(%R8,%RBX,1)                       | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nADD $0x40,%RBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nCMP %R13,%RBX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8751 <hypre_SeqVectorAxpy._omp_fn.0+0x3d1>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nMOV %RAX,%RSI                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nAND $-0x8,%RSI                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nADD %RSI,%RDX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nCMP %RSI,%RAX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJE 5a8820 <hypre_SeqVectorAxpy._omp_fn.0+0x4a0>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nSUB %RSI,%RAX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nMOV %RAX,%R11                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nLEA -0x1(%RAX),%RAX                              | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nCMP $0x2,%RAX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJBE 5a87a2 <hypre_SeqVectorAxpy._omp_fn.0+0x422> | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nADD %R12,%RSI                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVBROADCASTSD %XMM0,%YMM1                         | 1     | 0     | 0     | 0    | 0    | 0  | 1     | 0     | 0    | 3       | 1\nMOV %R11,%R9                                     | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nLEA (%RCX,%RSI,8),%R12                           | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nAND $-0x4,%R9                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVMOVUPD (%R12),%YMM3                             | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nADD %R9,%RDX                                     | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nAND $0x3,%R11D                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVFMADD132PD (%RDI,%RSI,8),%YMM3,%YMM1            | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVUPD %YMM1,(%R12)                             | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nJE 5a8820 <hypre_SeqVectorAxpy._omp_fn.0+0x4a0>  | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nVMOVSD (%RDI,%RDX,8),%XMM4                       | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nLEA (,%RDX,8),%R8                                | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nLEA 0x1(%RDX),%R13                               | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nLEA (%RCX,%R8,1),%RSI                            | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nVFMADD213SD (%RSI),%XMM0,%XMM4                   | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM4,(%RSI)                              | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nCMP %R13,%R10                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJLE 5a8820 <hypre_SeqVectorAxpy._omp_fn.0+0x4a0> | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nVMOVSD 0x8(%RDI,%R8,1),%XMM5                     | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nLEA 0x8(%RCX,%R8,1),%R11                         | 1     | 0     | 1     | 0    | 0    | 0  | 0     | 0     | 0    | 3       | 1\nADD $0x2,%RDX                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVFMADD213SD (%R11),%XMM0,%XMM5                   | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM5,(%R11)                              | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nCMP %RDX,%R10                                    | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nJLE 5a8820 <hypre_SeqVectorAxpy._omp_fn.0+0x4a0> | 1     | 0.50  | 0     | 0    | 0    | 0  | 0     | 0.50  | 0    | 0       | 0.50-1\nLEA 0x10(%RCX,%R8,1),%RDX                        | 1     | 0     | 1     | 0    | 0    | 0  | 0     | 0     | 0    | 3       | 1\nVMOVSD (%RDX),%XMM6                              | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4-5     | 0.50\nVFMADD132SD 0x10(%RDI,%R8,1),%XMM6,%XMM0         | 1     | 0.50  | 0.50  | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 4       | 0.50\nVMOVSD %XMM0,(%RDX)                              | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nVZEROUPPER                                       | 4     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 1\nLEA -0x18(%RBP),%RSP                             | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nPOP %RBX                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %R12                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %R13                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %RBP                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nRET                                              | 1     | 0     | 0     | 0.33 | 0.33 | 0  | 0     | 1     | 0.33 | 0       | 1\nNOPW %CS:(%RAX,%RAX,1)                           | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nINC %RAX                                         | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nXOR %EDX,%EDX                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nJMP 5a83b5 <hypre_SeqVectorAxpy._omp_fn.0+0x35>  | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 1     | 0    | 0       | 1-2\nNOPW (%RAX,%RAX,1)                               | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nVZEROUPPER                                       | 4     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 1\nLEA -0x18(%RBP),%RSP                             | 1     | 0     | 0.50  | 0    | 0    | 0  | 0.50  | 0     | 0    | 1       | 0.50\nPOP %RBX                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %R12                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %R13                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nPOP %RBP                                         | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 2       | 0.50\nRET                                              | 1     | 0     | 0     | 0.33 | 0.33 | 0  | 0     | 1     | 0.33 | 0       | 1\nVMOVUPD (%R9),%ZMM2                              | 1     | 0     | 0     | 0.50 | 0.50 | 0  | 0     | 0     | 0    | 5-6     | 0.50\nMOV $0x40,%EBX                                   | 1     | 0.25  | 0.25  | 0    | 0    | 0  | 0.25  | 0.25  | 0    | 1       | 0.25\nVFMADD213PD (%R8),%ZMM1,%ZMM2                    | 1     | 0.50  | 0     | 0.50 | 0.50 | 0  | 0.50  | 0     | 0    | 4       | 0.50\nVMOVUPD %ZMM2,(%R8)                              | 1     | 0     | 0     | 0.33 | 0.33 | 1  | 0     | 0     | 0.33 | 3       | 1\nJMP 5a85e5 <hypre_SeqVectorAxpy._omp_fn.0+0x265> | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 1     | 0    | 0       | 1-2\nXOR %ESI,%ESI                                    | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nJMP 5a8774 <hypre_SeqVectorAxpy._omp_fn.0+0x3f4> | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 1     | 0    | 0       | 1-2\nNOPW %CS:(%RAX,%RAX,1)                           | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\nNOPL (%RAX)                                      | 1     | 0     | 0     | 0    | 0    | 0  | 0     | 0     | 0    | 0       | 0.25\n",
        },
      },
      header = {
        "Warnings:\nDetected a function call instruction: ignoring called function instructions.\nRerun with --follow-calls=append to include them to analysis  or with --follow-calls=inline to simulate inlining.",
        "4% of peak computational performance is used (1.56 out of 32.00 FLOP per cycle (GFLOPS @ 1GHz))",
      },
      brief = {
      },
      gain = {
        {
          workaround = " - Try to reorganize arrays of structures to structures of arrays\n - Consider to permute loops (see vectorization gain report)\n",
          title = "Code clean check",
          txt = "Detected a slowdown caused by scalar integer instructions (typically used for address computation).\nBy removing them, you can lower the cost of an iteration from 90.00 to 28.00 cycles (3.21x speedup).",
        },
        {
          workaround = " - Try another compiler or update/tune your current one\n - Make array accesses unit-stride:\n  * If your function streams arrays of structures (AoS), try to use structures of arrays instead (SoA):\nfor(i) a[i].x = b[i].x; (slow, non stride 1) => for(i) a.x[i] = b.x[i]; (fast, stride 1)\n",
          details = "30% of SSE/AVX instructions are used in vector version (process two or more data elements in vector registers):\n - 43% of SSE/AVX loads are used in vector version.\n - 44% of SSE/AVX stores are used in vector version.\n - 44% of SSE/AVX fused multiply-add instructions are used in vector version.\n - 0% of SSE/AVX divide and square root instructions are used in vector version.\n - 6% of SSE/AVX instructions that are not load, store, addition, subtraction nor multiply instructions are used in vector version.\nSince your execution units are vector units, only a fully vectorized function can use their full power.\n",
          title = "Vectorization",
          txt = "Your function is poorly vectorized.\nOnly 35% of vector register length is used (average across all SSE/AVX instructions).\nBy fully vectorizing your function, you can lower the cost of an iteration from 90.00 to 53.18 cycles (1.69x speedup).",
        },
        {
          workaround = " - Reduce the number of division or square root instructions:\n  * If denominator is constant over iterations, use reciprocal (replace x/y with x*(1/y)). Check precision impact. This will be done by your compiler with ffast-math or Ofast\n - Check whether you really need double precision. If not, switch to single precision to speedup execution\n",
          title = "Execution units bottlenecks",
          txt = "Performance is limited by execution of divide and square root operations (the divide/square root unit is a bottleneck).\n\nBy removing all these bottlenecks, you can lower the cost of an iteration from 90.00 to 72.00 cycles (1.25x speedup).\n",
        },
      },
      potential = {
        {
          title = "Expensive FP math instructions/calls",
          txt = "Detected performance impact from expensive FP math instructions/calls.\nBy removing/reexpressing them, you can lower the cost of an iteration from 90.00 to 58.00 cycles (1.55x speedup).",
        },
        {
          title = "FMA",
          txt = "Detected 70 FMA (fused multiply-add) operations.",
        },
      },
    },
  common = {
    header = {
      "The function is defined in /home/kcamus/qaas_runs/169-443-9681/intel/AMG/build/AMG/AMG/seq_mv/vector.c:449-452.\n",
      "Warnings:\nIgnoring paths for analysis",
    },
  },
}
