_cqa_text_report = {
  paths = {
    {
      hint = {
        {
          details = "Calling (and then returning from) a function prevents many compiler optimizations (like vectorization), breaks control flow (which reduces pipeline performance) and executes extra instructions to save/restore the registers used inside it, which is very expensive (dozens of cycles). Consider to inline small functions.\n - GOMP_barrier@plt: 1 occurrences\n - hypre_CAlloc: 1 occurrences\n - hypre_Free: 1 occurrences\n - hypre_GetThreadNum: 1 occurrences\n - memset@plt: 1 occurrences\n",
          title = "CALL instructions",
          txt = "Detected function call instructions.\n",
        },
        {
          details = "These instructions generate more than one micro-operation and only one of them can be decoded during a cycle and the extra micro-operations increase pressure on execution units.\n - ADD: 34 occurrences\n - VZEROUPPER: 2 occurrences\n",
          title = "Complex instructions",
          txt = "Detected COMPLEX INSTRUCTIONS.\n",
        },
        {
          title = "Type of elements and instruction set",
          txt = "",
        },
        {
          title = "Matching between your function (in the source code) and the binary function",
          txt = "The binary function does not contain any FP arithmetical operations.\nThe binary function is loading 2888 bytes.\nThe binary function is storing 1584 bytes.",
        },
      },
      expert = {
        {
          title = "General properties",
          txt = "nb instructions    : 531\nnb uops            : 576\nloop length        : 2446\nused x86 registers : 16\nused mmx registers : 0\nused xmm registers : 16\nused ymm registers : 9\nused zmm registers : 16\nnb stack references: 30\n",
        },
        {
          title = "Front-end",
          txt = "MACRO FUSION NOT POSSIBLE\nFIT IN UOP CACHE\nmicro-operation queue: 152.00 cycles\nfront end            : 152.00 cycles\n",
        },
        {
          title = "Back-end",
          txt = "       | P0    | P1    | P2    | P3    | P4     | P5    | P6    | P7\n-----------------------------------------------------------------------\nuops   | 81.75 | 81.67 | 93.17 | 92.83 | 105.00 | 81.83 | 81.75 | 93.00\ncycles | 81.75 | 81.67 | 93.17 | 92.83 | 105.00 | 81.83 | 81.75 | 93.00\n\nCycles executing div or sqrt instructions: NA\n",
        },
        {
          title = "Front-end and detailed OoO resources (UFS)",
          txt = "FE+BE cycles: 159.47\nStall cycles: 0.00\n",
        },
        {
          title = "Cycles summary",
          txt = "Front-end : 152.00\nDispatch  : 105.00\nOverall L1: 152.00\n",
        },
        {
          title = "Vectorization ratios",
          txt = "all     : 36%\nload    : 47%\nstore   : 17%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : 100%\nfma     : NA (no fma vectorizable/vectorized instructions)\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 23%\n",
        },
        {
          title = "Vector efficiency ratios",
          txt = "all     : 33%\nload    : 50%\nstore   : 26%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : 77%\nfma     : NA (no fma vectorizable/vectorized instructions)\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 17%\n",
        },
        {
          title = "Cycles and memory resources usage",
          txt = "Assuming all data fit into the L1 cache, each call to the function takes 152.00 cycles. At this rate:\n - 14% of peak load performance is reached (19.00 out of 128.00 bytes loaded per cycle (GB/s @ 1GHz))\n - 16% of peak store performance is reached (10.42 out of 64.00 bytes stored per cycle (GB/s @ 1GHz))\n",
        },
        {
          title = "Front-end bottlenecks",
          txt = "Performance is limited by instruction throughput (loading/decoding program instructions to execution core) (front-end is a bottleneck).\n\nBy removing all these bottlenecks, you can lower the cost of an iteration from 152.00 to 105.00 cycles (1.45x speedup).\n",
        },
        {
          title = "ASM code",
          txt = "In the binary file, the address of the function is: 558f80\n\nInstruction                                           | Nb FU | P0   | P1   | P2   | P3   | P4 | P5   | P6   | P7   | Latency | Recip. throughput\n-------------------------------------------------------------------------------------------------------------------------------------------------\nPUSH %RBP                                             | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RSP,%RBP                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nPUSH %R15                                             | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nPUSH %R14                                             | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nPUSH %R13                                             | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nPUSH %R12                                             | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nPUSH %RBX                                             | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nAND $-0x40,%RSP                                       | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nSUB $0x100,%RSP                                       | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV 0xd0(%RDI),%RSI                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xc8(%RDI),%RCX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xc0(%RDI),%R11                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xb8(%RDI),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xb0(%RDI),%RBX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xa0(%RDI),%RDX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RSI,0x78(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x98(%RDI),%RAX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x88(%RDI),%R8                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RCX,0x90(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x80(%RDI),%R10                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x78(%RDI),%R12                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %R11,0xc0(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x70(%RDI),%R14                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x68(%RDI),%R15                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %R9,0xe8(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RBX,0x58(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x90(%RDI),%R13                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RDX,0xf8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0xa8(%RDI),%RBX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RAX,0xd8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R8,0x88(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R10,0x80(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R12,0x30(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R14,0xf0(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R15,0x50(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x60(%RDI),%RSI                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x58(%RDI),%RCX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x50(%RDI),%R11                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x40(%RDI),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x38(%RDI),%RDX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RSI,0xb0(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x28(%RDI),%R8                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x18(%RDI),%R12                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RCX,0x48(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x30(%RDI),%RAX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x20(%RDI),%R10                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %R11,0xa8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x10(%RDI),%R15                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x8(%RDI),%RSI                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %R9,0xa0(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x48(%RDI),%R14                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV (%RDI),%RDI                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RDX,0x68(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R8,0x98(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R12,0xc8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RAX,0xd0(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R10,0xb8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R15,0xe0(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RSI,0x40(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RDI,0x38(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nCALL 5b5180 <hypre_GetThreadNum>                      | 2     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 1    | 0.33 | 0       | 1\nMOV 0x78(%RSP),%R8                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xf8(%RSP),%RDX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xe8(%RSP),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xc0(%RSP),%R11                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RAX,%R12                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nCMP %RAX,%R8                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV 0x90(%RSP),%RCX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nJLE 559656 <hypre_ParMatmul_RowSizes._omp_fn.0+0x6d6> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %RCX,%R10                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %RDX,%RDI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nIMUL %RAX,%R10                                        | 1     | 0    | 1    | 0    | 0    | 0  | 0    | 0    | 0    | 3       | 1\nADD %R10,%RCX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nOR %R13,%RDI                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nLEA (%RAX,%R10,1),%R15                                | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA 0x1(%RAX,%RCX,1),%RSI                             | 1     | 0    | 1    | 0    | 0    | 0  | 0    | 0    | 0    | 3       | 1\nMOV %RSI,0x90(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nJNE 55967b <hypre_ParMatmul_RowSizes._omp_fn.0+0x6fb> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nXOR %EDI,%EDI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV 0x90(%RSP),%R8                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nCMP %R8,%R15                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJGE 559709 <hypre_ParMatmul_RowSizes._omp_fn.0+0x789> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV 0x38(%RSP),%RDX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x40(%RSP),%RCX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %R15,0x28(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RBX,%R10                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nCMPQ $0,0x88(%RSP)                                    | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nMOV %R11,0x20(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV (%RDX),%RAX                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV (%RCX),%RSI                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %R9,0x18(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R15,%RDX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %R13,0xf8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R12,0x10(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RAX,0x78(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RSI,0x70(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nJNE 559276 <hypre_ParMatmul_RowSizes._omp_fn.0+0x2f6> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nNOPW (%RAX,%RAX,1)                                    | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nNOPL (%RAX,%RAX,1)                                    | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nNOPL (%RAX)                                           | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nNOPL (%RAX)                                           | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV 0x28(%RSP),%R15                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x20(%RSP),%R11                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x18(%RSP),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x10(%RSP),%R12                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RCX,(%R9,%R12,8)                                 | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R8,(%R11,%R12,8)                                 | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R9,0xf0(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R11,0xf8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nCALL 5b1eb0 <hypre_Free>                              | 2     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 1    | 0.33 | 0       | 1\nCALL 40f290 <GOMP_barrier@plt>                        | 2     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 1    | 0.33 | 0       | 1\nTEST %R12,%R12                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV 0xf8(%RSP),%R14                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xf0(%RSP),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nJNE 559714 <hypre_ParMatmul_RowSizes._omp_fn.0+0x794> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV 0x38(%RSP),%RDI                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x30(%RSP),%R10                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x40(%RSP),%R8                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x58(%RSP),%R11                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV (%RDI),%RCX                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nSAL $0x3,%R10                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nADD %R10,%RCX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD (%R8),%R10                                        | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nMOVQ $0,(%RCX)                                        | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 2       | 1\nMOVQ $0,(%R10)                                        | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 2       | 1\nTEST %R11,%R11                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 559647 <hypre_ParMatmul_RowSizes._omp_fn.0+0x6c7> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nAND $0x7,%R11D                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5595a5 <hypre_ParMatmul_RowSizes._omp_fn.0+0x625>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x1,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559589 <hypre_ParMatmul_RowSizes._omp_fn.0+0x609>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x2,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559578 <hypre_ParMatmul_RowSizes._omp_fn.0+0x5f8>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x3,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559567 <hypre_ParMatmul_RowSizes._omp_fn.0+0x5e7>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x4,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559556 <hypre_ParMatmul_RowSizes._omp_fn.0+0x5d6>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x5,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559545 <hypre_ParMatmul_RowSizes._omp_fn.0+0x5c5>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x6,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559534 <hypre_ParMatmul_RowSizes._omp_fn.0+0x5b4>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV (%R9),%R15                                        | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV $0x1,%R12D                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R15,(%RCX)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R14),%RDX                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD %RDX,(%R10)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R9,%R12,8),%RSI                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD %RSI,(%RCX)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R14,%R12,8),%R13                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nINC %R12                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R13,(%R10)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R9,%R12,8),%RAX                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD %RAX,(%RCX)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R14,%R12,8),%RDI                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nINC %R12                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDI,(%R10)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R9,%R12,8),%R8                                  | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD %R8,(%RCX)                                        | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R14,%R12,8),%R11                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nINC %R12                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R11,(%R10)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R9,%R12,8),%RBX                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD %RBX,(%RCX)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R14,%R12,8),%R15                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nINC %R12                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R15,(%R10)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R9,%R12,8),%RDX                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD %RDX,(%RCX)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R14,%R12,8),%RSI                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nINC %R12                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RSI,(%R10)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R9,%R12,8),%R13                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD %R13,(%RCX)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R14,%R12,8),%RAX                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nINC %R12                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RAX,(%R10)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nCMP %R12,0x58(%RSP)                                   | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nJE 559647 <hypre_ParMatmul_RowSizes._omp_fn.0+0x6c7>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nLEA -0x28(%RBP),%RSP                                  | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nPOP %RBX                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R12                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R13                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R14                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R15                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %RBP                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nRET                                                   | 1     | 0    | 0    | 0.33 | 0.33 | 0  | 0    | 1    | 0.33 | 0       | 1\nMOV %RCX,%RAX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %RDX,%RDI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nIMUL %R12,%RAX                                        | 1     | 0    | 1    | 0    | 0    | 0  | 0    | 0    | 0    | 3       | 1\nLEA (%R8,%RAX,1),%R15                                 | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD %RCX,%RAX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R8,%RAX                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nOR %R13,%RDI                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV %RAX,0x90(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nJE 559129 <hypre_ParMatmul_RowSizes._omp_fn.0+0x1a9>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD %R13,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV $0x8,%ESI                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV %R9,0xc0(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RDX,%RDI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %R11,0xe8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RDX,0xf8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nCALL 5b1df0 <hypre_CAlloc>                            | 2     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 1    | 0.33 | 0       | 1\nMOV 0xf8(%RSP),%RDX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xe8(%RSP),%R11                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xc0(%RSP),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RAX,%RDI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nTEST %RDX,%RDX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 55912b <hypre_ParMatmul_RowSizes._omp_fn.0+0x1ab> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nSAL $0x3,%RDX                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nMOV $0xff,%ESI                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV %R9,0xe8(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R11,0xf8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nCALL 40f0a0 <memset@plt>                              | 2     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 1    | 0.33 | 0       | 1\nMOV 0x90(%RSP),%R8                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xf8(%RSP),%R11                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xe8(%RSP),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RAX,%RDI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nCMP %R8,%R15                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJL 55913c <hypre_ParMatmul_RowSizes._omp_fn.0+0x1bc>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %RBX,%R8                                          | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %RBX,%RCX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nJMP 55947d <hypre_ParMatmul_RowSizes._omp_fn.0+0x4fd> | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 1    | 0    | 0       | 1-2\nMOV (%R9),%R13                                        | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV (%R14),%RDI                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nCMP $0x1,%R12                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 559e42 <hypre_ParMatmul_RowSizes._omp_fn.0+0xec2> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nLEA -0x2(%R12),%RCX                                   | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA -0x1(%R12),%R10                                   | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nCMP $0x6,%RCX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJBE 559e4d <hypre_ParMatmul_RowSizes._omp_fn.0+0xecd> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %R10,%RDX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nVPXOR %XMM3,%XMM3,%XMM3                               | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV $0x8,%EAX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nSHR $0x3,%RDX                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nVMOVDQA64 %ZMM3,%ZMM1                                 | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nSAL $0x6,%RDX                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nLEA 0x8(%RDX),%R11                                    | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nSUB $0x40,%RDX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nSHR $0x6,%RDX                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nINC %RDX                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x7,%EDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559820 <hypre_ParMatmul_RowSizes._omp_fn.0+0x8a0>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x1,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559805 <hypre_ParMatmul_RowSizes._omp_fn.0+0x885>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x2,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5597f3 <hypre_ParMatmul_RowSizes._omp_fn.0+0x873>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x3,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5597e1 <hypre_ParMatmul_RowSizes._omp_fn.0+0x861>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x4,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5597cf <hypre_ParMatmul_RowSizes._omp_fn.0+0x84f>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x5,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5597bd <hypre_ParMatmul_RowSizes._omp_fn.0+0x83d>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x6,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5597ab <hypre_ParMatmul_RowSizes._omp_fn.0+0x82b>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVMOVDQU64 0x8(%R9),%ZMM1                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nVMOVDQU64 0x8(%R14),%ZMM3                             | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nMOV $0x48,%EAX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R9,%RAX,1),%ZMM1,%ZMM1                       | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVPADDQ (%R14,%RAX,1),%ZMM3,%ZMM3                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD $0x40,%RAX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R9,%RAX,1),%ZMM1,%ZMM1                       | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVPADDQ (%R14,%RAX,1),%ZMM3,%ZMM3                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD $0x40,%RAX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R9,%RAX,1),%ZMM1,%ZMM1                       | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVPADDQ (%R14,%RAX,1),%ZMM3,%ZMM3                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD $0x40,%RAX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R9,%RAX,1),%ZMM1,%ZMM1                       | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVPADDQ (%R14,%RAX,1),%ZMM3,%ZMM3                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD $0x40,%RAX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R9,%RAX,1),%ZMM1,%ZMM1                       | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVPADDQ (%R14,%RAX,1),%ZMM3,%ZMM3                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD $0x40,%RAX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R9,%RAX,1),%ZMM1,%ZMM1                       | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVPADDQ (%R14,%RAX,1),%ZMM3,%ZMM3                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD $0x40,%RAX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP %RAX,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5598ad <hypre_ParMatmul_RowSizes._omp_fn.0+0x92d>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVMOVDQA %YMM3,%YMM4                                   | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nVEXTRACTI64X4 $0x1,%ZMM1,%YMM10                       | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nVEXTRACTI64X4 $0x1,%ZMM3,%YMM3                        | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nMOV %R10,%RSI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nVPADDQ %YMM3,%YMM4,%YMM2                              | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVPADDQ %YMM1,%YMM10,%YMM0                             | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nAND $-0x8,%RSI                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVEXTRACTI64X2 $0x1,%YMM2,%XMM6                        | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nVEXTRACTI64X2 $0x1,%YMM0,%XMM11                       | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nLEA 0x1(%RSI),%R8                                     | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVPADDQ %XMM6,%XMM2,%XMM7                              | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVPADDQ %XMM11,%XMM0,%XMM12                            | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVPSRLDQ $0x8,%XMM7,%XMM8                              | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVPSRLDQ $0x8,%XMM12,%XMM13                            | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVPADDQ %XMM8,%XMM7,%XMM9                              | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVPADDQ %XMM13,%XMM12,%XMM14                           | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVMOVQ %XMM9,%RAX                                      | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 2       | 1\nVMOVQ %XMM14,%RDX                                     | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 2       | 1\nADD %RDI,%RAX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R13,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x7,%R10D                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5599ba <hypre_ParMatmul_RowSizes._omp_fn.0+0xa3a>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %R12,%R10                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nSUB %RSI,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nLEA -0x1(%R10),%RBX                                   | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nSUB $0x2,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP $0x2,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJBE 559984 <hypre_ParMatmul_RowSizes._omp_fn.0+0xa04> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVPADDQ 0x8(%R9,%RSI,8),%YMM0,%YMM15                   | 1     | 0.33 | 0.33 | 0.50 | 0.50 | 0  | 0.33 | 0    | 0    | 1       | 0.50\nVPADDQ 0x8(%R14,%RSI,8),%YMM2,%YMM2                   | 1     | 0.33 | 0.33 | 0.50 | 0.50 | 0  | 0.33 | 0    | 0    | 1       | 0.50\nVEXTRACTI64X2 $0x1,%YMM15,%XMM8                       | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nVEXTRACTI64X2 $0x1,%YMM2,%XMM4                        | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nVPADDQ %XMM8,%XMM15,%XMM9                             | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVPADDQ %XMM4,%XMM2,%XMM3                              | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVPSRLDQ $0x8,%XMM9,%XMM10                             | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVPSRLDQ $0x8,%XMM3,%XMM5                              | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVPADDQ %XMM10,%XMM9,%XMM1                             | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVPADDQ %XMM5,%XMM3,%XMM6                              | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVMOVQ %XMM1,%RDX                                      | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 2       | 1\nVMOVQ %XMM6,%RAX                                      | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 2       | 1\nADD %R13,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV %RBX,%R13                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nADD %RDI,%RAX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $-0x4,%R13                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R13,%R8                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x3,%EBX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5599ba <hypre_ParMatmul_RowSizes._omp_fn.0+0xa3a>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nLEA 0x1(%R8),%RDI                                     | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA (,%R8,8),%RCX                                     | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD (%R9,%R8,8),%RDX                                  | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nADD (%R14,%R8,8),%RAX                                 | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nCMP %RDI,%R12                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 5599ba <hypre_ParMatmul_RowSizes._omp_fn.0+0xa3a> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD $0x2,%R8                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD 0x8(%R9,%RCX,1),%RDX                              | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nADD 0x8(%R14,%RCX,1),%RAX                             | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nCMP %R8,%R12                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 5599ba <hypre_ParMatmul_RowSizes._omp_fn.0+0xa3a> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD 0x10(%R9,%RCX,1),%RDX                             | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nADD 0x10(%R14,%RCX,1),%RAX                            | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nMOV 0x90(%RSP),%R14                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nCMP %R14,%R15                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJGE 559b13 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb93> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nSUB %R15,%R14                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV 0x38(%RSP),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x40(%RSP),%R12                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %R15,%RDI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nLEA -0x1(%R14),%R10                                   | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nMOV %R14,%R11                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV (%R9),%R13                                        | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV (%R12),%RSI                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nCMP $0x2,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJBE 559a1f <hypre_ParMatmul_RowSizes._omp_fn.0+0xa9f> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nLEA (,%R15,8),%R8                                     | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA 0x40(,%R15,8),%RCX                                | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA (%RSI,%R8,1),%R14                                 | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA (%RSI,%RCX,1),%RBX                                | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD %R13,%R8                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP %RBX,%R8                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJAE 559b25 <hypre_ParMatmul_RowSizes._omp_fn.0+0xba5> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD %R13,%RCX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP %RCX,%R14                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJAE 559b25 <hypre_ParMatmul_RowSizes._omp_fn.0+0xba5> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV 0x90(%RSP),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nSUB %R15,%R9                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x7,%R9D                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559ab6 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb36>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x1,%R9                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559aa0 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb20>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x2,%R9                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559a94 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb14>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x3,%R9                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559a88 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb08>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x4,%R9                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559a7c <hypre_ParMatmul_RowSizes._omp_fn.0+0xafc>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x5,%R9                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559a70 <hypre_ParMatmul_RowSizes._omp_fn.0+0xaf0>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x6,%R9                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559a64 <hypre_ParMatmul_RowSizes._omp_fn.0+0xae4>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD %RDX,(%R13,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nINC %R15                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDX,(%R13,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nINC %R15                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDX,(%R13,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nINC %R15                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDX,(%R13,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nINC %R15                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDX,(%R13,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nINC %R15                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDX,(%R13,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nINC %R15                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDX,(%R13,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nINC %R15                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP %R15,0x90(%RSP)                                   | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nJE 559b13 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb93>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVZEROUPPER                                            | 4     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 1\nLEA -0x28(%RBP),%RSP                                  | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nPOP %RBX                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R12                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R13                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R14                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R15                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %RBP                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nRET                                                   | 1     | 0    | 0    | 0.33 | 0.33 | 0  | 0    | 1    | 0.33 | 0       | 1\nCMP $0x6,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJBE 559e68 <hypre_ParMatmul_RowSizes._omp_fn.0+0xee8> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %R11,%RBX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nVPBROADCASTQ %RDX,%ZMM11                              | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVPBROADCASTQ %RAX,%ZMM12                              | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nXOR %ECX,%ECX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nSHR $0x3,%RBX                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nSAL $0x6,%RBX                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nLEA -0x40(%RBX),%R10                                  | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nSHR $0x6,%R10                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nINC %R10                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x7,%R10D                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559c73 <hypre_ParMatmul_RowSizes._omp_fn.0+0xcf3>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x1,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559c4a <hypre_ParMatmul_RowSizes._omp_fn.0+0xcca>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x2,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559c2a <hypre_ParMatmul_RowSizes._omp_fn.0+0xcaa>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x3,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559c0a <hypre_ParMatmul_RowSizes._omp_fn.0+0xc8a>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x4,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559bea <hypre_ParMatmul_RowSizes._omp_fn.0+0xc6a>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x5,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559bca <hypre_ParMatmul_RowSizes._omp_fn.0+0xc4a>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x6,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559baa <hypre_ParMatmul_RowSizes._omp_fn.0+0xc2a>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVPADDQ (%R8),%ZMM11,%ZMM13                            | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nMOV $0x40,%ECX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVMOVDQU64 %ZMM13,(%R8)                                | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R14),%ZMM12,%ZMM14                           | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM14,(%R14)                               | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R8,%RCX,1),%ZMM11,%ZMM15                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM15,(%R8,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R14,%RCX,1),%ZMM12,%ZMM2                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM2,(%R14,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nADD $0x40,%RCX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R8,%RCX,1),%ZMM11,%ZMM0                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM0,(%R8,%RCX,1)                          | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R14,%RCX,1),%ZMM12,%ZMM4                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM4,(%R14,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nADD $0x40,%RCX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R8,%RCX,1),%ZMM11,%ZMM3                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM3,(%R8,%RCX,1)                          | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R14,%RCX,1),%ZMM12,%ZMM5                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM5,(%R14,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nADD $0x40,%RCX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R8,%RCX,1),%ZMM11,%ZMM6                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM6,(%R8,%RCX,1)                          | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R14,%RCX,1),%ZMM12,%ZMM7                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM7,(%R14,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nADD $0x40,%RCX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R8,%RCX,1),%ZMM11,%ZMM8                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM8,(%R8,%RCX,1)                          | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R14,%RCX,1),%ZMM12,%ZMM9                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM9,(%R14,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nADD $0x40,%RCX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R8,%RCX,1),%ZMM11,%ZMM10                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM10,(%R8,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R14,%RCX,1),%ZMM12,%ZMM1                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM1,(%R14,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nADD $0x40,%RCX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP %RCX,%RBX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559d7f <hypre_ParMatmul_RowSizes._omp_fn.0+0xdff>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %R11,%R12                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nAND $-0x8,%R12                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R12,%R15                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nTEST $0x7,%R11B                                       | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559b13 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb93>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nSUB %R12,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nLEA -0x1(%R11),%R8                                    | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nCMP $0x2,%R8                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJBE 559de3 <hypre_ParMatmul_RowSizes._omp_fn.0+0xe63> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD %RDI,%R12                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPBROADCASTQ %RDX,%YMM11                              | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVPBROADCASTQ %RAX,%YMM15                              | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nMOV %R11,%R14                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nSAL $0x3,%R12                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nAND $-0x4,%R14                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nLEA (%R13,%R12,1),%RDI                                | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD %RSI,%R12                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R14,%R15                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x3,%R11D                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%RDI),%YMM11,%YMM12                           | 1     | 0.33 | 0.33 | 0.50 | 0.50 | 0  | 0.33 | 0    | 0    | 1       | 0.50\nVMOVDQU %YMM12,(%RDI)                                 | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R12),%YMM15,%YMM2                            | 1     | 0.33 | 0.33 | 0.50 | 0.50 | 0  | 0.33 | 0    | 0    | 1       | 0.50\nVMOVDQU %YMM2,(%R12)                                  | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nJE 559b13 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb93>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nLEA (,%R15,8),%R11                                    | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nMOV 0x90(%RSP),%R12                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nLEA 0x1(%R15),%R9                                     | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD %RDX,(%R13,%R11,1)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R11,1)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nCMP %R9,%R12                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 559b13 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb93> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nLEA 0x8(%R11),%RBX                                    | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA 0x2(%R15),%R15                                    | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD %RDX,(%R13,%RBX,1)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%RBX,1)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nCMP %R15,%R12                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 559b13 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb93> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD $0x10,%R11                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDX,(%R13,%R11,1)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R11,1)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nVZEROUPPER                                            | 4     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 1\nLEA -0x28(%RBP),%RSP                                  | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nPOP %RBX                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R12                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R13                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R14                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R15                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %RBP                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nRET                                                   | 1     | 0    | 0    | 0.33 | 0.33 | 0  | 0    | 1    | 0.33 | 0       | 1\nMOV %RDI,%RAX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %R13,%RDX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nJMP 5599ba <hypre_ParMatmul_RowSizes._omp_fn.0+0xa3a> | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 1    | 0    | 0       | 1-2\nVPXOR %XMM2,%XMM2,%XMM2                               | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %RDI,%RAX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %R13,%RDX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nXOR %ESI,%ESI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nVMOVDQA %YMM2,%YMM0                                   | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV $0x1,%R8D                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJMP 559918 <hypre_ParMatmul_RowSizes._omp_fn.0+0x998> | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 1    | 0    | 0       | 1-2\nXOR %R12D,%R12D                                       | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nJMP 559da0 <hypre_ParMatmul_RowSizes._omp_fn.0+0xe20> | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 1    | 0    | 0       | 1-2\n",
        },
      },
      header = {
        "Warnings:\nDetected a function call instruction: ignoring called function instructions.\nRerun with --follow-calls=append to include them to analysis  or with --follow-calls=inline to simulate inlining.",
        "0% of peak computational performance is used (0.00 out of 64.00 FLOP per cycle (GFLOPS @ 1GHz))",
      },
      brief = {
      },
      gain = {
        {
          workaround = " - Try to reorganize arrays of structures to structures of arrays\n - Consider to permute loops (see vectorization gain report)\n",
          title = "Code clean check",
          txt = "Detected a slowdown caused by scalar integer instructions (typically used for address computation).\nBy removing them, you can lower the cost of an iteration from 152.00 to 50.00 cycles (3.04x speedup).",
        },
        {
          workaround = " - Try another compiler or update/tune your current one\n - Make array accesses unit-stride:\n  * If your function streams arrays of structures (AoS), try to use structures of arrays instead (SoA):\nfor(i) a[i].x = b[i].x; (slow, non stride 1) => for(i) a.x[i] = b.x[i]; (fast, stride 1)\n",
          details = "36% of SSE/AVX instructions are used in vector version (process two or more data elements in vector registers):\n - 47% of SSE/AVX loads are used in vector version.\n - 17% of SSE/AVX stores are used in vector version.\n - 23% of SSE/AVX instructions that are not load, store, addition, subtraction nor multiply instructions are used in vector version.\nSince your execution units are vector units, only a fully vectorized function can use their full power.\n",
          title = "Vectorization",
          txt = "Your function is poorly vectorized.\nOnly 33% of vector register length is used (average across all SSE/AVX instructions).\nBy fully vectorizing your function, you can lower the cost of an iteration from 152.00 to 114.36 cycles (1.33x speedup).",
        },
        {
          title = "Execution units bottlenecks",
          txt = "Found no such bottlenecks but see expert reports for more complex bottlenecks.",
        },
      },
      potential = {
      },
    },
  },
  AVG = {
      hint = {
        {
          details = "Calling (and then returning from) a function prevents many compiler optimizations (like vectorization), breaks control flow (which reduces pipeline performance) and executes extra instructions to save/restore the registers used inside it, which is very expensive (dozens of cycles). Consider to inline small functions.\n - GOMP_barrier@plt: 1 occurrences\n - hypre_CAlloc: 1 occurrences\n - hypre_Free: 1 occurrences\n - hypre_GetThreadNum: 1 occurrences\n - memset@plt: 1 occurrences\n",
          title = "CALL instructions",
          txt = "Detected function call instructions.\n",
        },
        {
          details = "These instructions generate more than one micro-operation and only one of them can be decoded during a cycle and the extra micro-operations increase pressure on execution units.\n - ADD: 34 occurrences\n - VZEROUPPER: 2 occurrences\n",
          title = "Complex instructions",
          txt = "Detected COMPLEX INSTRUCTIONS.\n",
        },
        {
          title = "Type of elements and instruction set",
          txt = "",
        },
        {
          title = "Matching between your function (in the source code) and the binary function",
          txt = "The binary function does not contain any FP arithmetical operations.\nThe binary function is loading 2888 bytes.\nThe binary function is storing 1584 bytes.",
        },
      },
      expert = {
        {
          title = "General properties",
          txt = "nb instructions    : 531\nnb uops            : 576\nloop length        : 2446\nused x86 registers : 16\nused mmx registers : 0\nused xmm registers : 16\nused ymm registers : 9\nused zmm registers : 16\nnb stack references: 30\n",
        },
        {
          title = "Front-end",
          txt = "MACRO FUSION NOT POSSIBLE\nFIT IN UOP CACHE\nmicro-operation queue: 152.00 cycles\nfront end            : 152.00 cycles\n",
        },
        {
          title = "Back-end",
          txt = "       | P0    | P1    | P2    | P3    | P4     | P5    | P6    | P7\n-----------------------------------------------------------------------\nuops   | 81.75 | 81.67 | 93.17 | 92.83 | 105.00 | 81.83 | 81.75 | 93.00\ncycles | 81.75 | 81.67 | 93.17 | 92.83 | 105.00 | 81.83 | 81.75 | 93.00\n\nCycles executing div or sqrt instructions: NA\n",
        },
        {
          title = "Front-end and detailed OoO resources (UFS)",
          txt = "FE+BE cycles: 159.47\nStall cycles: 0.00\n",
        },
        {
          title = "Cycles summary",
          txt = "Front-end : 152.00\nDispatch  : 105.00\nOverall L1: 152.00\n",
        },
        {
          title = "Vectorization ratios",
          txt = "all     : 36%\nload    : 47%\nstore   : 17%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : 100%\nfma     : NA (no fma vectorizable/vectorized instructions)\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 23%\n",
        },
        {
          title = "Vector efficiency ratios",
          txt = "all     : 33%\nload    : 50%\nstore   : 26%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : 77%\nfma     : NA (no fma vectorizable/vectorized instructions)\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 17%\n",
        },
        {
          title = "Cycles and memory resources usage",
          txt = "Assuming all data fit into the L1 cache, each call to the function takes 152.00 cycles. At this rate:\n - 14% of peak load performance is reached (19.00 out of 128.00 bytes loaded per cycle (GB/s @ 1GHz))\n - 16% of peak store performance is reached (10.42 out of 64.00 bytes stored per cycle (GB/s @ 1GHz))\n",
        },
        {
          title = "Front-end bottlenecks",
          txt = "Performance is limited by instruction throughput (loading/decoding program instructions to execution core) (front-end is a bottleneck).\n\nBy removing all these bottlenecks, you can lower the cost of an iteration from 152.00 to 105.00 cycles (1.45x speedup).\n",
        },
        {
          title = "ASM code",
          txt = "In the binary file, the address of the function is: 558f80\n\nInstruction                                           | Nb FU | P0   | P1   | P2   | P3   | P4 | P5   | P6   | P7   | Latency | Recip. throughput\n-------------------------------------------------------------------------------------------------------------------------------------------------\nPUSH %RBP                                             | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RSP,%RBP                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nPUSH %R15                                             | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nPUSH %R14                                             | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nPUSH %R13                                             | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nPUSH %R12                                             | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nPUSH %RBX                                             | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nAND $-0x40,%RSP                                       | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nSUB $0x100,%RSP                                       | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV 0xd0(%RDI),%RSI                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xc8(%RDI),%RCX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xc0(%RDI),%R11                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xb8(%RDI),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xb0(%RDI),%RBX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xa0(%RDI),%RDX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RSI,0x78(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x98(%RDI),%RAX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x88(%RDI),%R8                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RCX,0x90(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x80(%RDI),%R10                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x78(%RDI),%R12                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %R11,0xc0(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x70(%RDI),%R14                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x68(%RDI),%R15                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %R9,0xe8(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RBX,0x58(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x90(%RDI),%R13                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RDX,0xf8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0xa8(%RDI),%RBX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RAX,0xd8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R8,0x88(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R10,0x80(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R12,0x30(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R14,0xf0(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R15,0x50(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x60(%RDI),%RSI                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x58(%RDI),%RCX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x50(%RDI),%R11                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x40(%RDI),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x38(%RDI),%RDX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RSI,0xb0(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x28(%RDI),%R8                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x18(%RDI),%R12                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RCX,0x48(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x30(%RDI),%RAX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x20(%RDI),%R10                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %R11,0xa8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x10(%RDI),%R15                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x8(%RDI),%RSI                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %R9,0xa0(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV 0x48(%RDI),%R14                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV (%RDI),%RDI                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RDX,0x68(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R8,0x98(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R12,0xc8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RAX,0xd0(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R10,0xb8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R15,0xe0(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RSI,0x40(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RDI,0x38(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nCALL 5b5180 <hypre_GetThreadNum>                      | 2     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 1    | 0.33 | 0       | 1\nMOV 0x78(%RSP),%R8                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xf8(%RSP),%RDX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xe8(%RSP),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xc0(%RSP),%R11                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RAX,%R12                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nCMP %RAX,%R8                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV 0x90(%RSP),%RCX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nJLE 559656 <hypre_ParMatmul_RowSizes._omp_fn.0+0x6d6> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %RCX,%R10                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %RDX,%RDI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nIMUL %RAX,%R10                                        | 1     | 0    | 1    | 0    | 0    | 0  | 0    | 0    | 0    | 3       | 1\nADD %R10,%RCX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nOR %R13,%RDI                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nLEA (%RAX,%R10,1),%R15                                | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA 0x1(%RAX,%RCX,1),%RSI                             | 1     | 0    | 1    | 0    | 0    | 0  | 0    | 0    | 0    | 3       | 1\nMOV %RSI,0x90(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nJNE 55967b <hypre_ParMatmul_RowSizes._omp_fn.0+0x6fb> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nXOR %EDI,%EDI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV 0x90(%RSP),%R8                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nCMP %R8,%R15                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJGE 559709 <hypre_ParMatmul_RowSizes._omp_fn.0+0x789> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV 0x38(%RSP),%RDX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x40(%RSP),%RCX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %R15,0x28(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RBX,%R10                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nCMPQ $0,0x88(%RSP)                                    | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nMOV %R11,0x20(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV (%RDX),%RAX                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV (%RCX),%RSI                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %R9,0x18(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R15,%RDX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %R13,0xf8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R12,0x10(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RAX,0x78(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RSI,0x70(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nJNE 559276 <hypre_ParMatmul_RowSizes._omp_fn.0+0x2f6> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nNOPW (%RAX,%RAX,1)                                    | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nNOPL (%RAX,%RAX,1)                                    | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nNOPL (%RAX)                                           | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nNOPL (%RAX)                                           | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV 0x28(%RSP),%R15                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x20(%RSP),%R11                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x18(%RSP),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x10(%RSP),%R12                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RCX,(%R9,%R12,8)                                 | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R8,(%R11,%R12,8)                                 | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R9,0xf0(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R11,0xf8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nCALL 5b1eb0 <hypre_Free>                              | 2     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 1    | 0.33 | 0       | 1\nCALL 40f290 <GOMP_barrier@plt>                        | 2     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 1    | 0.33 | 0       | 1\nTEST %R12,%R12                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV 0xf8(%RSP),%R14                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xf0(%RSP),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nJNE 559714 <hypre_ParMatmul_RowSizes._omp_fn.0+0x794> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV 0x38(%RSP),%RDI                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x30(%RSP),%R10                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x40(%RSP),%R8                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x58(%RSP),%R11                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV (%RDI),%RCX                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nSAL $0x3,%R10                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nADD %R10,%RCX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD (%R8),%R10                                        | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nMOVQ $0,(%RCX)                                        | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 2       | 1\nMOVQ $0,(%R10)                                        | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 2       | 1\nTEST %R11,%R11                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 559647 <hypre_ParMatmul_RowSizes._omp_fn.0+0x6c7> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nAND $0x7,%R11D                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5595a5 <hypre_ParMatmul_RowSizes._omp_fn.0+0x625>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x1,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559589 <hypre_ParMatmul_RowSizes._omp_fn.0+0x609>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x2,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559578 <hypre_ParMatmul_RowSizes._omp_fn.0+0x5f8>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x3,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559567 <hypre_ParMatmul_RowSizes._omp_fn.0+0x5e7>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x4,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559556 <hypre_ParMatmul_RowSizes._omp_fn.0+0x5d6>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x5,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559545 <hypre_ParMatmul_RowSizes._omp_fn.0+0x5c5>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x6,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559534 <hypre_ParMatmul_RowSizes._omp_fn.0+0x5b4>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV (%R9),%R15                                        | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV $0x1,%R12D                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R15,(%RCX)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R14),%RDX                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD %RDX,(%R10)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R9,%R12,8),%RSI                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD %RSI,(%RCX)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R14,%R12,8),%R13                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nINC %R12                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R13,(%R10)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R9,%R12,8),%RAX                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD %RAX,(%RCX)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R14,%R12,8),%RDI                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nINC %R12                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDI,(%R10)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R9,%R12,8),%R8                                  | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD %R8,(%RCX)                                        | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R14,%R12,8),%R11                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nINC %R12                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R11,(%R10)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R9,%R12,8),%RBX                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD %RBX,(%RCX)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R14,%R12,8),%R15                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nINC %R12                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R15,(%R10)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R9,%R12,8),%RDX                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD %RDX,(%RCX)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R14,%R12,8),%RSI                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nINC %R12                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RSI,(%R10)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R9,%R12,8),%R13                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD %R13,(%RCX)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nMOV (%R14,%R12,8),%RAX                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nINC %R12                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RAX,(%R10)                                       | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nCMP %R12,0x58(%RSP)                                   | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nJE 559647 <hypre_ParMatmul_RowSizes._omp_fn.0+0x6c7>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nLEA -0x28(%RBP),%RSP                                  | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nPOP %RBX                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R12                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R13                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R14                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R15                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %RBP                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nRET                                                   | 1     | 0    | 0    | 0.33 | 0.33 | 0  | 0    | 1    | 0.33 | 0       | 1\nMOV %RCX,%RAX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %RDX,%RDI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nIMUL %R12,%RAX                                        | 1     | 0    | 1    | 0    | 0    | 0  | 0    | 0    | 0    | 3       | 1\nLEA (%R8,%RAX,1),%R15                                 | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD %RCX,%RAX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R8,%RAX                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nOR %R13,%RDI                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV %RAX,0x90(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nJE 559129 <hypre_ParMatmul_RowSizes._omp_fn.0+0x1a9>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD %R13,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV $0x8,%ESI                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV %R9,0xc0(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RDX,%RDI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %R11,0xe8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %RDX,0xf8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nCALL 5b1df0 <hypre_CAlloc>                            | 2     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 1    | 0.33 | 0       | 1\nMOV 0xf8(%RSP),%RDX                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xe8(%RSP),%R11                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xc0(%RSP),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RAX,%RDI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nTEST %RDX,%RDX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 55912b <hypre_ParMatmul_RowSizes._omp_fn.0+0x1ab> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nSAL $0x3,%RDX                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nMOV $0xff,%ESI                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV %R9,0xe8(%RSP)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nMOV %R11,0xf8(%RSP)                                   | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nCALL 40f0a0 <memset@plt>                              | 2     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 1    | 0.33 | 0       | 1\nMOV 0x90(%RSP),%R8                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xf8(%RSP),%R11                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0xe8(%RSP),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %RAX,%RDI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nCMP %R8,%R15                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJL 55913c <hypre_ParMatmul_RowSizes._omp_fn.0+0x1bc>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %RBX,%R8                                          | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %RBX,%RCX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nJMP 55947d <hypre_ParMatmul_RowSizes._omp_fn.0+0x4fd> | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 1    | 0    | 0       | 1-2\nMOV (%R9),%R13                                        | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV (%R14),%RDI                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nCMP $0x1,%R12                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 559e42 <hypre_ParMatmul_RowSizes._omp_fn.0+0xec2> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nLEA -0x2(%R12),%RCX                                   | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA -0x1(%R12),%R10                                   | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nCMP $0x6,%RCX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJBE 559e4d <hypre_ParMatmul_RowSizes._omp_fn.0+0xecd> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %R10,%RDX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nVPXOR %XMM3,%XMM3,%XMM3                               | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV $0x8,%EAX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nSHR $0x3,%RDX                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nVMOVDQA64 %ZMM3,%ZMM1                                 | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nSAL $0x6,%RDX                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nLEA 0x8(%RDX),%R11                                    | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nSUB $0x40,%RDX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nSHR $0x6,%RDX                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nINC %RDX                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x7,%EDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559820 <hypre_ParMatmul_RowSizes._omp_fn.0+0x8a0>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x1,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559805 <hypre_ParMatmul_RowSizes._omp_fn.0+0x885>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x2,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5597f3 <hypre_ParMatmul_RowSizes._omp_fn.0+0x873>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x3,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5597e1 <hypre_ParMatmul_RowSizes._omp_fn.0+0x861>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x4,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5597cf <hypre_ParMatmul_RowSizes._omp_fn.0+0x84f>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x5,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5597bd <hypre_ParMatmul_RowSizes._omp_fn.0+0x83d>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x6,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5597ab <hypre_ParMatmul_RowSizes._omp_fn.0+0x82b>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVMOVDQU64 0x8(%R9),%ZMM1                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nVMOVDQU64 0x8(%R14),%ZMM3                             | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nMOV $0x48,%EAX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R9,%RAX,1),%ZMM1,%ZMM1                       | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVPADDQ (%R14,%RAX,1),%ZMM3,%ZMM3                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD $0x40,%RAX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R9,%RAX,1),%ZMM1,%ZMM1                       | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVPADDQ (%R14,%RAX,1),%ZMM3,%ZMM3                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD $0x40,%RAX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R9,%RAX,1),%ZMM1,%ZMM1                       | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVPADDQ (%R14,%RAX,1),%ZMM3,%ZMM3                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD $0x40,%RAX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R9,%RAX,1),%ZMM1,%ZMM1                       | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVPADDQ (%R14,%RAX,1),%ZMM3,%ZMM3                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD $0x40,%RAX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R9,%RAX,1),%ZMM1,%ZMM1                       | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVPADDQ (%R14,%RAX,1),%ZMM3,%ZMM3                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD $0x40,%RAX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R9,%RAX,1),%ZMM1,%ZMM1                       | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVPADDQ (%R14,%RAX,1),%ZMM3,%ZMM3                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD $0x40,%RAX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP %RAX,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5598ad <hypre_ParMatmul_RowSizes._omp_fn.0+0x92d>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVMOVDQA %YMM3,%YMM4                                   | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nVEXTRACTI64X4 $0x1,%ZMM1,%YMM10                       | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nVEXTRACTI64X4 $0x1,%ZMM3,%YMM3                        | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nMOV %R10,%RSI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nVPADDQ %YMM3,%YMM4,%YMM2                              | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVPADDQ %YMM1,%YMM10,%YMM0                             | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nAND $-0x8,%RSI                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVEXTRACTI64X2 $0x1,%YMM2,%XMM6                        | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nVEXTRACTI64X2 $0x1,%YMM0,%XMM11                       | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nLEA 0x1(%RSI),%R8                                     | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVPADDQ %XMM6,%XMM2,%XMM7                              | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVPADDQ %XMM11,%XMM0,%XMM12                            | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVPSRLDQ $0x8,%XMM7,%XMM8                              | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVPSRLDQ $0x8,%XMM12,%XMM13                            | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVPADDQ %XMM8,%XMM7,%XMM9                              | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVPADDQ %XMM13,%XMM12,%XMM14                           | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVMOVQ %XMM9,%RAX                                      | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 2       | 1\nVMOVQ %XMM14,%RDX                                     | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 2       | 1\nADD %RDI,%RAX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R13,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x7,%R10D                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5599ba <hypre_ParMatmul_RowSizes._omp_fn.0+0xa3a>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %R12,%R10                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nSUB %RSI,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nLEA -0x1(%R10),%RBX                                   | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nSUB $0x2,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP $0x2,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJBE 559984 <hypre_ParMatmul_RowSizes._omp_fn.0+0xa04> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVPADDQ 0x8(%R9,%RSI,8),%YMM0,%YMM15                   | 1     | 0.33 | 0.33 | 0.50 | 0.50 | 0  | 0.33 | 0    | 0    | 1       | 0.50\nVPADDQ 0x8(%R14,%RSI,8),%YMM2,%YMM2                   | 1     | 0.33 | 0.33 | 0.50 | 0.50 | 0  | 0.33 | 0    | 0    | 1       | 0.50\nVEXTRACTI64X2 $0x1,%YMM15,%XMM8                       | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nVEXTRACTI64X2 $0x1,%YMM2,%XMM4                        | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nVPADDQ %XMM8,%XMM15,%XMM9                             | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVPADDQ %XMM4,%XMM2,%XMM3                              | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVPSRLDQ $0x8,%XMM9,%XMM10                             | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVPSRLDQ $0x8,%XMM3,%XMM5                              | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVPADDQ %XMM10,%XMM9,%XMM1                             | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVPADDQ %XMM5,%XMM3,%XMM6                              | 1     | 0.33 | 0.33 | 0    | 0    | 0  | 0.33 | 0    | 0    | 1       | 0.33\nVMOVQ %XMM1,%RDX                                      | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 2       | 1\nVMOVQ %XMM6,%RAX                                      | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 2       | 1\nADD %R13,%RDX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV %RBX,%R13                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nADD %RDI,%RAX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $-0x4,%R13                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R13,%R8                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x3,%EBX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5599ba <hypre_ParMatmul_RowSizes._omp_fn.0+0xa3a>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nLEA 0x1(%R8),%RDI                                     | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA (,%R8,8),%RCX                                     | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD (%R9,%R8,8),%RDX                                  | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nADD (%R14,%R8,8),%RAX                                 | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nCMP %RDI,%R12                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 5599ba <hypre_ParMatmul_RowSizes._omp_fn.0+0xa3a> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD $0x2,%R8                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD 0x8(%R9,%RCX,1),%RDX                              | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nADD 0x8(%R14,%RCX,1),%RAX                             | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nCMP %R8,%R12                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 5599ba <hypre_ParMatmul_RowSizes._omp_fn.0+0xa3a> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD 0x10(%R9,%RCX,1),%RDX                             | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nADD 0x10(%R14,%RCX,1),%RAX                            | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nMOV 0x90(%RSP),%R14                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nCMP %R14,%R15                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJGE 559b13 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb93> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nSUB %R15,%R14                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nMOV 0x38(%RSP),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x40(%RSP),%R12                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV %R15,%RDI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nLEA -0x1(%R14),%R10                                   | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nMOV %R14,%R11                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV (%R9),%R13                                        | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV (%R12),%RSI                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nCMP $0x2,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJBE 559a1f <hypre_ParMatmul_RowSizes._omp_fn.0+0xa9f> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nLEA (,%R15,8),%R8                                     | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA 0x40(,%R15,8),%RCX                                | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA (%RSI,%R8,1),%R14                                 | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA (%RSI,%RCX,1),%RBX                                | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD %R13,%R8                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP %RBX,%R8                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJAE 559b25 <hypre_ParMatmul_RowSizes._omp_fn.0+0xba5> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD %R13,%RCX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP %RCX,%R14                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJAE 559b25 <hypre_ParMatmul_RowSizes._omp_fn.0+0xba5> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV 0x90(%RSP),%R9                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nSUB %R15,%R9                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x7,%R9D                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559ab6 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb36>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x1,%R9                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559aa0 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb20>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x2,%R9                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559a94 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb14>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x3,%R9                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559a88 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb08>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x4,%R9                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559a7c <hypre_ParMatmul_RowSizes._omp_fn.0+0xafc>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x5,%R9                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559a70 <hypre_ParMatmul_RowSizes._omp_fn.0+0xaf0>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x6,%R9                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559a64 <hypre_ParMatmul_RowSizes._omp_fn.0+0xae4>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD %RDX,(%R13,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nINC %R15                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDX,(%R13,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nINC %R15                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDX,(%R13,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nINC %R15                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDX,(%R13,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nINC %R15                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDX,(%R13,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nINC %R15                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDX,(%R13,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nINC %R15                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDX,(%R13,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R15,8)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nINC %R15                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP %R15,0x90(%RSP)                                   | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nJE 559b13 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb93>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVZEROUPPER                                            | 4     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 1\nLEA -0x28(%RBP),%RSP                                  | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nPOP %RBX                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R12                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R13                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R14                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R15                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %RBP                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nRET                                                   | 1     | 0    | 0    | 0.33 | 0.33 | 0  | 0    | 1    | 0.33 | 0       | 1\nCMP $0x6,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJBE 559e68 <hypre_ParMatmul_RowSizes._omp_fn.0+0xee8> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %R11,%RBX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nVPBROADCASTQ %RDX,%ZMM11                              | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVPBROADCASTQ %RAX,%ZMM12                              | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nXOR %ECX,%ECX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nSHR $0x3,%RBX                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nSAL $0x6,%RBX                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nLEA -0x40(%RBX),%R10                                  | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nSHR $0x6,%R10                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nINC %R10                                              | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x7,%R10D                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559c73 <hypre_ParMatmul_RowSizes._omp_fn.0+0xcf3>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x1,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559c4a <hypre_ParMatmul_RowSizes._omp_fn.0+0xcca>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x2,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559c2a <hypre_ParMatmul_RowSizes._omp_fn.0+0xcaa>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x3,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559c0a <hypre_ParMatmul_RowSizes._omp_fn.0+0xc8a>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x4,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559bea <hypre_ParMatmul_RowSizes._omp_fn.0+0xc6a>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x5,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559bca <hypre_ParMatmul_RowSizes._omp_fn.0+0xc4a>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x6,%R10                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559baa <hypre_ParMatmul_RowSizes._omp_fn.0+0xc2a>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVPADDQ (%R8),%ZMM11,%ZMM13                            | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nMOV $0x40,%ECX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVMOVDQU64 %ZMM13,(%R8)                                | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R14),%ZMM12,%ZMM14                           | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM14,(%R14)                               | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R8,%RCX,1),%ZMM11,%ZMM15                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM15,(%R8,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R14,%RCX,1),%ZMM12,%ZMM2                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM2,(%R14,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nADD $0x40,%RCX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R8,%RCX,1),%ZMM11,%ZMM0                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM0,(%R8,%RCX,1)                          | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R14,%RCX,1),%ZMM12,%ZMM4                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM4,(%R14,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nADD $0x40,%RCX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R8,%RCX,1),%ZMM11,%ZMM3                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM3,(%R8,%RCX,1)                          | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R14,%RCX,1),%ZMM12,%ZMM5                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM5,(%R14,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nADD $0x40,%RCX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R8,%RCX,1),%ZMM11,%ZMM6                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM6,(%R8,%RCX,1)                          | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R14,%RCX,1),%ZMM12,%ZMM7                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM7,(%R14,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nADD $0x40,%RCX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R8,%RCX,1),%ZMM11,%ZMM8                      | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM8,(%R8,%RCX,1)                          | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R14,%RCX,1),%ZMM12,%ZMM9                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM9,(%R14,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nADD $0x40,%RCX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%R8,%RCX,1),%ZMM11,%ZMM10                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM10,(%R8,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R14,%RCX,1),%ZMM12,%ZMM1                     | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVDQU64 %ZMM1,(%R14,%RCX,1)                         | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nADD $0x40,%RCX                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP %RCX,%RBX                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559d7f <hypre_ParMatmul_RowSizes._omp_fn.0+0xdff>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %R11,%R12                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nAND $-0x8,%R12                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R12,%R15                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nTEST $0x7,%R11B                                       | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 559b13 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb93>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nSUB %R12,%R11                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nLEA -0x1(%R11),%R8                                    | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nCMP $0x2,%R8                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJBE 559de3 <hypre_ParMatmul_RowSizes._omp_fn.0+0xe63> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD %RDI,%R12                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPBROADCASTQ %RDX,%YMM11                              | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVPBROADCASTQ %RAX,%YMM15                              | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nMOV %R11,%R14                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nSAL $0x3,%R12                                         | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nAND $-0x4,%R14                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nLEA (%R13,%R12,1),%RDI                                | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD %RSI,%R12                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R14,%R15                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x3,%R11D                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVPADDQ (%RDI),%YMM11,%YMM12                           | 1     | 0.33 | 0.33 | 0.50 | 0.50 | 0  | 0.33 | 0    | 0    | 1       | 0.50\nVMOVDQU %YMM12,(%RDI)                                 | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nVPADDQ (%R12),%YMM15,%YMM2                            | 1     | 0.33 | 0.33 | 0.50 | 0.50 | 0  | 0.33 | 0    | 0    | 1       | 0.50\nVMOVDQU %YMM2,(%R12)                                  | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 4       | 1\nJE 559b13 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb93>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nLEA (,%R15,8),%R11                                    | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nMOV 0x90(%RSP),%R12                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nLEA 0x1(%R15),%R9                                     | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD %RDX,(%R13,%R11,1)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R11,1)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nCMP %R9,%R12                                          | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 559b13 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb93> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nLEA 0x8(%R11),%RBX                                    | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA 0x2(%R15),%R15                                    | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD %RDX,(%R13,%RBX,1)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%RBX,1)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nCMP %R15,%R12                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 559b13 <hypre_ParMatmul_RowSizes._omp_fn.0+0xb93> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD $0x10,%R11                                        | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %RDX,(%R13,%R11,1)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nADD %RAX,(%RSI,%R11,1)                                | 2     | 0.25 | 0.25 | 0.83 | 0.83 | 1  | 0.25 | 0.25 | 0.33 | 5       | 1\nVZEROUPPER                                            | 4     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 1\nLEA -0x28(%RBP),%RSP                                  | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nPOP %RBX                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R12                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R13                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R14                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %R15                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nPOP %RBP                                              | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 2       | 0.50\nRET                                                   | 1     | 0    | 0    | 0.33 | 0.33 | 0  | 0    | 1    | 0.33 | 0       | 1\nMOV %RDI,%RAX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %R13,%RDX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nJMP 5599ba <hypre_ParMatmul_RowSizes._omp_fn.0+0xa3a> | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 1    | 0    | 0       | 1-2\nVPXOR %XMM2,%XMM2,%XMM2                               | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %RDI,%RAX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %R13,%RDX                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nXOR %ESI,%ESI                                         | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nVMOVDQA %YMM2,%YMM0                                   | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV $0x1,%R8D                                         | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJMP 559918 <hypre_ParMatmul_RowSizes._omp_fn.0+0x998> | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 1    | 0    | 0       | 1-2\nXOR %R12D,%R12D                                       | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nJMP 559da0 <hypre_ParMatmul_RowSizes._omp_fn.0+0xe20> | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 1    | 0    | 0       | 1-2\n",
        },
      },
      header = {
        "Warnings:\nDetected a function call instruction: ignoring called function instructions.\nRerun with --follow-calls=append to include them to analysis  or with --follow-calls=inline to simulate inlining.",
        "0% of peak computational performance is used (0.00 out of 64.00 FLOP per cycle (GFLOPS @ 1GHz))",
      },
      brief = {
      },
      gain = {
        {
          workaround = " - Try to reorganize arrays of structures to structures of arrays\n - Consider to permute loops (see vectorization gain report)\n",
          title = "Code clean check",
          txt = "Detected a slowdown caused by scalar integer instructions (typically used for address computation).\nBy removing them, you can lower the cost of an iteration from 152.00 to 50.00 cycles (3.04x speedup).",
        },
        {
          workaround = " - Try another compiler or update/tune your current one\n - Make array accesses unit-stride:\n  * If your function streams arrays of structures (AoS), try to use structures of arrays instead (SoA):\nfor(i) a[i].x = b[i].x; (slow, non stride 1) => for(i) a.x[i] = b.x[i]; (fast, stride 1)\n",
          details = "36% of SSE/AVX instructions are used in vector version (process two or more data elements in vector registers):\n - 47% of SSE/AVX loads are used in vector version.\n - 17% of SSE/AVX stores are used in vector version.\n - 23% of SSE/AVX instructions that are not load, store, addition, subtraction nor multiply instructions are used in vector version.\nSince your execution units are vector units, only a fully vectorized function can use their full power.\n",
          title = "Vectorization",
          txt = "Your function is poorly vectorized.\nOnly 33% of vector register length is used (average across all SSE/AVX instructions).\nBy fully vectorizing your function, you can lower the cost of an iteration from 152.00 to 114.36 cycles (1.33x speedup).",
        },
        {
          title = "Execution units bottlenecks",
          txt = "Found no such bottlenecks but see expert reports for more complex bottlenecks.",
        },
      },
      potential = {
      },
    },
  common = {
    header = {
      "The function is defined in /home/kcamus/qaas_runs/169-443-9681/intel/AMG/build/AMG/AMG/parcsr_mv/par_csr_matop.c:102-127,135-137,144-146,154-156,164-177,187,195,205-208,216-220,228-231,241-276.\n",
      "Warnings:\nIgnoring paths for analysis",
    },
  },
}
