_cqa_text_report = {
  paths = {
    {
      hint = {
        {
          details = "These instructions generate more than one micro-operation and only one of them can be decoded during a cycle and the extra micro-operations increase pressure on execution units.\n - VGATHERQPD: 8 occurrences\n",
          title = "Complex instructions",
          txt = "Detected COMPLEX INSTRUCTIONS.\n",
        },
        {
          workaround = "Use vector aligned instructions:\n 1) align your arrays on 64 bytes boundaries: replace { void *p = malloc (size); } with { void *p; posix_memalign (&p, 64, size); }.\n 2) inform your compiler that your arrays are vector aligned: if array 'foo' is 64 bytes-aligned, define a pointer 'p_foo' as __builtin_assume_aligned (foo, 64) and use it instead of 'foo' in the loop.\n",
          details = " - VEXTRACTF64X2: 2 occurrences\n - VEXTRACTF64X4: 1 occurrences\n",
          title = "Vector unaligned load/store instructions",
          txt = "Detected 3 suboptimal vector unaligned load/store instructions.\n",
        },
        {
          workaround = "Try to simplify your code and/or replace indirect accesses with unit-stride ones.",
          details = " - VGATHERQPD: 8 occurrences\n",
          title = "Gather/scatter instructions",
          txt = "Detected gather/scatter instructions (typically caused by indirect accesses).",
        },
        {
          title = "Type of elements and instruction set",
          txt = "5 SSE or AVX instructions are processing arithmetic or math operations on double precision FP elements in scalar mode (one at a time).\n4 SSE or AVX instructions are processing arithmetic or math operations on double precision FP elements in vector mode (two at a time).\n3 AVX instructions are processing arithmetic or math operations on double precision FP elements in vector mode (four at a time).\n7 AVX-512 instructions are processing arithmetic or math operations on double precision FP elements in vector mode (eight at a time).\n",
        },
        {
          title = "Matching between your loop (in the source code) and the binary loop",
          txt = "The binary loop is composed of 144 FP arithmetical operations:\n - 81: addition or subtraction (63 inside FMA instructions)\n - 63: multiply (all inside FMA instructions)\nThe binary loop is loading 1560 bytes (195 double precision FP elements).\nThe binary loop is storing 8 bytes (1 double precision FP elements).",
        },
        {
          title = "Arithmetic intensity",
          txt = "Arithmetic intensity is 0.09 FP operations per loaded or stored byte.",
        },
      },
      expert = {
        {
          title = "General properties",
          txt = "nb instructions    : 135\nnb uops            : 159\nloop length        : 643\nused x86 registers : 15\nused mmx registers : 0\nused xmm registers : 13\nused ymm registers : 6\nused zmm registers : 15\nnb stack references: 3\n",
        },
        {
          title = "Front-end",
          txt = "MACRO FUSION NOT POSSIBLE\nFIT IN UOP CACHE\nmicro-operation queue: 42.25 cycles\nfront end            : 42.25 cycles\n",
        },
        {
          title = "Back-end",
          txt = "       | P0    | P1    | P2    | P3    | P4   | P5    | P6    | P7\n--------------------------------------------------------------------\nuops   | 28.50 | 28.50 | 45.50 | 45.50 | 1.00 | 28.50 | 28.50 | 1.00\ncycles | 28.50 | 28.50 | 45.50 | 45.50 | 1.00 | 28.50 | 28.50 | 1.00\n\nCycles executing div or sqrt instructions: NA\n",
        },
        {
          title = "Front-end and detailed OoO resources (UFS)",
          txt = "FE+BE cycles     : 82.68\nStall cycles     : 43.88\nROB full (events): 52.16\n",
        },
        {
          title = "Cycles summary",
          txt = "Front-end : 42.25\nDispatch  : 45.50\nOverall L1: 45.50\n",
        },
        {
          title = "Vectorization ratios",
          txt = "INT\nall    : 34%\nload   : 100%\nstore  : NA (no store vectorizable/vectorized instructions)\nmul    : NA (no mul vectorizable/vectorized instructions)\nadd-sub: NA (no add-sub vectorizable/vectorized instructions)\nfma    : NA (no fma vectorizable/vectorized instructions)\nother  : 0%\nFP\nall     : 64%\nload    : 69%\nstore   : 0%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : 75%\nfma     : 72%\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 72%\nINT+FP\nall     : 53%\nload    : 77%\nstore   : 0%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : 75%\nfma     : 72%\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 39%\n",
        },
        {
          title = "Vector efficiency ratios",
          txt = "INT\nall    : 40%\nload   : 93%\nstore  : NA (no store vectorizable/vectorized instructions)\nmul    : NA (no mul vectorizable/vectorized instructions)\nadd-sub: NA (no add-sub vectorizable/vectorized instructions)\nfma    : NA (no fma vectorizable/vectorized instructions)\nother  : 12%\nFP\nall     : 48%\nload    : 69%\nstore   : 12%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : 28%\nfma     : 71%\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 53%\nINT+FP\nall     : 45%\nload    : 75%\nstore   : 12%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : 28%\nfma     : 71%\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 34%\n",
        },
        {
          title = "Cycles and memory resources usage",
          txt = "Assuming all data fit into the L1 cache, each iteration of the binary loop takes 45.50 cycles. At this rate:\n - 26% of peak load performance is reached (34.29 out of 128.00 bytes loaded per cycle (GB/s @ 1GHz))\n - 0% of peak store performance is reached (0.18 out of 64.00 bytes stored per cycle (GB/s @ 1GHz))\n",
        },
        {
          title = "Front-end bottlenecks",
          txt = "Found no such bottlenecks.",
        },
        {
          title = "ASM code",
          txt = "In the binary file, the address of the loop is: 5a21f0\n\nInstruction                                                   | Nb FU | P0   | P1   | P2   | P3   | P4 | P5   | P6   | P7   | Latency | Recip. throughput\n---------------------------------------------------------------------------------------------------------------------------------------------------------\nMOV 0x28(%RSP),%RAX                                           | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV (%R8,%R12,8),%RDX                                         | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x8(%R8,%R12,8),%R11                                      | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nVMOVSD (%RAX,%R12,8),%XMM2                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nCMP %R11,%RDX                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJGE 5a251f <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x246f> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %R11,%RSI                                                 | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %RDX,%R15                                                 | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nSUB %RDX,%RSI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nLEA -0x1(%RSI),%RCX                                           | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nCMP $0x6,%RCX                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJBE 5a2c1b <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2b6b> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %RSI,%R10                                                 | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nLEA (,%RDX,8),%RCX                                            | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVXORPD %XMM0,%XMM0,%XMM0                                      | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nXOR %EAX,%EAX                                                 | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nSHR $0x3,%R10                                                 | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nLEA (%R14,%RCX,1),%R9                                         | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD %R13,%RCX                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nSAL $0x6,%R10                                                 | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nLEA -0x40(%R10),%RDI                                          | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nSHR $0x6,%RDI                                                 | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nINC %RDI                                                      | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x7,%EDI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a235b <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x22ab>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x1,%RDI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a2335 <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2285>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x2,%RDI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a2318 <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2268>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x3,%RDI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a22fb <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x224b>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x4,%RDI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a22de <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x222e>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x5,%RDI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a22c1 <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2211>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x6,%RDI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a22a4 <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x21f4>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVMOVDQU64 (%RCX),%ZMM15                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nKMOVB %K0,%K5                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nMOV $0x40,%EAX                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVGATHERQPD (%RBX,%ZMM15,8),%ZMM6{%K5}                         | 4     | 1    | 0    | 4    | 4    | 0  | 1    | 0    | 0    | 21      | 5\nVFMADD231PD (%R9),%ZMM6,%ZMM0                                 | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 4       | 0.50\nVMOVDQU64 (%RCX,%RAX,1),%ZMM7                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nKMOVB %K0,%K6                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nVGATHERQPD (%RBX,%ZMM7,8),%ZMM10{%K6}                         | 4     | 1    | 0    | 4    | 4    | 0  | 1    | 0    | 0    | 21      | 5\nVFMADD231PD (%R9,%RAX,1),%ZMM10,%ZMM0                         | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 4       | 0.50\nADD $0x40,%RAX                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVMOVDQU64 (%RCX,%RAX,1),%ZMM11                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nKMOVB %K0,%K3                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nVGATHERQPD (%RBX,%ZMM11,8),%ZMM12{%K3}                        | 4     | 1    | 0    | 4    | 4    | 0  | 1    | 0    | 0    | 21      | 5\nVFMADD231PD (%R9,%RAX,1),%ZMM12,%ZMM0                         | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 4       | 0.50\nADD $0x40,%RAX                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVMOVDQU64 (%RCX,%RAX,1),%ZMM4                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nKMOVB %K0,%K7                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nVGATHERQPD (%RBX,%ZMM4,8),%ZMM9{%K7}                          | 4     | 1    | 0    | 4    | 4    | 0  | 1    | 0    | 0    | 21      | 5\nVFMADD231PD (%R9,%RAX,1),%ZMM9,%ZMM0                          | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 4       | 0.50\nADD $0x40,%RAX                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVMOVDQU64 (%RCX,%RAX,1),%ZMM13                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nKMOVB %K0,%K4                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nVGATHERQPD (%RBX,%ZMM13,8),%ZMM3{%K4}                         | 4     | 1    | 0    | 4    | 4    | 0  | 1    | 0    | 0    | 21      | 5\nVFMADD231PD (%R9,%RAX,1),%ZMM3,%ZMM0                          | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 4       | 0.50\nADD $0x40,%RAX                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVMOVDQU64 (%RCX,%RAX,1),%ZMM5                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nKMOVB %K0,%K2                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nVGATHERQPD (%RBX,%ZMM5,8),%ZMM1{%K2}                          | 4     | 1    | 0    | 4    | 4    | 0  | 1    | 0    | 0    | 21      | 5\nVFMADD231PD (%R9,%RAX,1),%ZMM1,%ZMM0                          | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 4       | 0.50\nADD $0x40,%RAX                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVMOVDQU64 (%RCX,%RAX,1),%ZMM8                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nKMOVB %K0,%K1                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nVGATHERQPD (%RBX,%ZMM8,8),%ZMM14{%K1}                         | 4     | 1    | 0    | 4    | 4    | 0  | 1    | 0    | 0    | 21      | 5\nVFMADD231PD (%R9,%RAX,1),%ZMM14,%ZMM0                         | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 4       | 0.50\nADD $0x40,%RAX                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP %RAX,%R10                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a2440 <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2390>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVEXTRACTF64X4 $0x1,%ZMM0,%YMM15                               | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nMOV %RSI,%R9                                                  | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nVADDPD %YMM0,%YMM15,%YMM6                                     | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nAND $-0x8,%R9                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVADDPD %YMM15,%YMM0,%YMM14                                    | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nADD %R9,%RDX                                                  | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVEXTRACTF64X2 $0x1,%YMM6,%XMM7                                | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nVADDPD %XMM6,%XMM7,%XMM10                                     | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nVUNPCKHPD %XMM10,%XMM10,%XMM11                                | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVADDPD %XMM10,%XMM11,%XMM12                                   | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nVADDSD %XMM12,%XMM2,%XMM8                                     | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nTEST $0x7,%SIL                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a253d <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x248d>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nSUB %R9,%RSI                                                  | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nLEA -0x1(%RSI),%RCX                                           | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nCMP $0x2,%RCX                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJBE 5a2c6c <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2bbc> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD %R15,%R9                                                  | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nKMOVB %K0,%K6                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nMOV %RSI,%R15                                                 | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nVMOVDQU (%R13,%R9,8),%YMM4                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nAND $-0x4,%R15                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R15,%RDX                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x3,%ESI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVGATHERQPD (%RBX,%YMM4,8),%YMM9{%K6}                          | 4     | 1    | 0    | 2    | 2    | 0  | 1    | 0    | 0    | 20      | 4\nVFMADD231PD (%R14,%R9,8),%YMM9,%YMM14                         | 1     | 0.50 | 0.50 | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4       | 0.50\nVEXTRACTF64X2 $0x1,%YMM14,%XMM13                              | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nVADDPD %XMM14,%XMM13,%XMM3                                    | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nVUNPCKHPD %XMM3,%XMM3,%XMM8                                   | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVADDPD %XMM3,%XMM8,%XMM5                                      | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nVADDSD %XMM5,%XMM2,%XMM2                                      | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nJE 5a251f <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x246f>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV (%R13,%RDX,8),%R9                                         | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nLEA 0x1(%RDX),%R10                                            | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA (,%RDX,8),%RSI                                            | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVSD (%RBX,%R9,8),%XMM1                                     | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nVFMADD231SD (%R14,%RDX,8),%XMM1,%XMM2                         | 1     | 0.50 | 0.50 | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4       | 0.50\nCMP %R10,%R11                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 5a251f <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x246f> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV 0x8(%R13,%RSI,1),%RDI                                     | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD $0x2,%RDX                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVMOVSD (%RBX,%RDI,8),%XMM14                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nVFMADD231SD 0x8(%R14,%RSI,1),%XMM14,%XMM2                     | 1     | 0.50 | 0.50 | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4       | 0.50\nCMP %R11,%RDX                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJGE 5a251f <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x246f> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV 0x10(%R13,%RSI,1),%RDX                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nVMOVSD 0x10(%R14,%RSI,1),%XMM0                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nVFMADD231SD (%RBX,%RDX,8),%XMM0,%XMM2                         | 1     | 0.50 | 0.50 | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4       | 0.50\nMOV 0x30(%RSP),%R11                                           | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nVMOVSD %XMM2,(%R11,%R12,8)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nINC %R12                                                      | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP %R12,0x38(%RSP)                                           | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nJNE 5a21f0 <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2140> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVMOVSD %XMM8,%XMM8,%XMM2                                      | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nJMP 5a251f <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x246f> | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 1    | 0    | 0       | 1-2\nVMOVSD %XMM2,%XMM2,%XMM8                                      | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVXORPD %XMM14,%XMM14,%XMM14                                   | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nXOR %R9D,%R9D                                                 | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nJMP 5a247e <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x23ce> | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 1    | 0    | 0       | 1-2\nVMOVSD %XMM8,%XMM8,%XMM2                                      | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nJMP 5a24d1 <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2421> | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 1    | 0    | 0       | 1-2\n",
        },
      },
      header = {
        "9% of peak computational performance is used (3.16 out of 32.00 FLOP per cycle (GFLOPS @ 1GHz))",
      },
      brief = {
      },
      gain = {
        {
          workaround = " - Try to reorganize arrays of structures to structures of arrays\n - Consider to permute loops (see vectorization gain report)\n",
          title = "Code clean check",
          txt = "Detected a slowdown caused by scalar integer instructions (typically used for address computation).\nBy removing them, you can lower the cost of an iteration from 45.50 to 42.00 cycles (1.08x speedup).",
        },
        {
          workaround = " - Try another compiler or update/tune your current one\n - Remove inter-iterations dependences from your loop and make it unit-stride:\n  * If your arrays have 2 or more dimensions, check whether elements are accessed contiguously and, otherwise, try to permute loops accordingly:\nC storage order is row-major: for(i) for(j) a[j][i] = b[j][i]; (slow, non stride 1) => for(i) for(j) a[i][j] = b[i][j]; (fast, stride 1)\n  * If your loop streams arrays of structures (AoS), try to use structures of arrays instead (SoA):\nfor(i) a[i].x = b[i].x; (slow, non stride 1) => for(i) a.x[i] = b.x[i]; (fast, stride 1)\n",
          details = "53% of SSE/AVX instructions are used in vector version (process two or more data elements in vector registers):\n - 77% of SSE/AVX loads are used in vector version.\n - 0% of SSE/AVX stores are used in vector version.\n - 75% of SSE/AVX addition or subtraction instructions are used in vector version.\n - 72% of SSE/AVX fused multiply-add instructions are used in vector version.\n - 39% of SSE/AVX instructions that are not load, store, addition, subtraction nor multiply instructions are used in vector version.\nSince your execution units are vector units, only a fully vectorized loop can use their full power.\n",
          title = "Vectorization",
          txt = "Your loop is partially vectorized.\nOnly 45% of vector register length is used (average across all SSE/AVX instructions).\nBy fully vectorizing your loop, you can lower the cost of an iteration from 45.50 to 40.94 cycles (1.11x speedup).",
        },
        {
          workaround = " - Read less array elements\n - Write less array elements\n - Provide more information to your compiler:\n  * hardcode the bounds of the corresponding 'for' loop\n  * use the 'restrict' C99 keyword\n",
          title = "Execution units bottlenecks",
          txt = "Performance is limited by:\n - reading data from caches/RAM (load units are a bottleneck)\n - writing data to caches/RAM (the store unit is a bottleneck)\n\nBy removing all these bottlenecks, you can lower the cost of an iteration from 45.50 to 42.25 cycles (1.08x speedup).\n",
        },
      },
      potential = {
        {
          title = "FMA",
          txt = "Detected 63 FMA (fused multiply-add) operations.",
        },
      },
    },
  },
  AVG = {
      hint = {
        {
          details = "These instructions generate more than one micro-operation and only one of them can be decoded during a cycle and the extra micro-operations increase pressure on execution units.\n - VGATHERQPD: 8 occurrences\n",
          title = "Complex instructions",
          txt = "Detected COMPLEX INSTRUCTIONS.\n",
        },
        {
          workaround = "Use vector aligned instructions:\n 1) align your arrays on 64 bytes boundaries: replace { void *p = malloc (size); } with { void *p; posix_memalign (&p, 64, size); }.\n 2) inform your compiler that your arrays are vector aligned: if array 'foo' is 64 bytes-aligned, define a pointer 'p_foo' as __builtin_assume_aligned (foo, 64) and use it instead of 'foo' in the loop.\n",
          details = " - VEXTRACTF64X2: 2 occurrences\n - VEXTRACTF64X4: 1 occurrences\n",
          title = "Vector unaligned load/store instructions",
          txt = "Detected 3 suboptimal vector unaligned load/store instructions.\n",
        },
        {
          workaround = "Try to simplify your code and/or replace indirect accesses with unit-stride ones.",
          details = " - VGATHERQPD: 8 occurrences\n",
          title = "Gather/scatter instructions",
          txt = "Detected gather/scatter instructions (typically caused by indirect accesses).",
        },
        {
          title = "Type of elements and instruction set",
          txt = "5 SSE or AVX instructions are processing arithmetic or math operations on double precision FP elements in scalar mode (one at a time).\n4 SSE or AVX instructions are processing arithmetic or math operations on double precision FP elements in vector mode (two at a time).\n3 AVX instructions are processing arithmetic or math operations on double precision FP elements in vector mode (four at a time).\n7 AVX-512 instructions are processing arithmetic or math operations on double precision FP elements in vector mode (eight at a time).\n",
        },
        {
          title = "Matching between your loop (in the source code) and the binary loop",
          txt = "The binary loop is composed of 144 FP arithmetical operations:\n - 81: addition or subtraction (63 inside FMA instructions)\n - 63: multiply (all inside FMA instructions)\nThe binary loop is loading 1560 bytes (195 double precision FP elements).\nThe binary loop is storing 8 bytes (1 double precision FP elements).",
        },
        {
          title = "Arithmetic intensity",
          txt = "Arithmetic intensity is 0.09 FP operations per loaded or stored byte.",
        },
      },
      expert = {
        {
          title = "General properties",
          txt = "nb instructions    : 135\nnb uops            : 159\nloop length        : 643\nused x86 registers : 15\nused mmx registers : 0\nused xmm registers : 13\nused ymm registers : 6\nused zmm registers : 15\nnb stack references: 3\n",
        },
        {
          title = "Front-end",
          txt = "MACRO FUSION NOT POSSIBLE\nFIT IN UOP CACHE\nmicro-operation queue: 42.25 cycles\nfront end            : 42.25 cycles\n",
        },
        {
          title = "Back-end",
          txt = "       | P0    | P1    | P2    | P3    | P4   | P5    | P6    | P7\n--------------------------------------------------------------------\nuops   | 28.50 | 28.50 | 45.50 | 45.50 | 1.00 | 28.50 | 28.50 | 1.00\ncycles | 28.50 | 28.50 | 45.50 | 45.50 | 1.00 | 28.50 | 28.50 | 1.00\n\nCycles executing div or sqrt instructions: NA\n",
        },
        {
          title = "Front-end and detailed OoO resources (UFS)",
          txt = "FE+BE cycles     : 82.68\nStall cycles     : 43.88\nROB full (events): 52.16\n",
        },
        {
          title = "Cycles summary",
          txt = "Front-end : 42.25\nDispatch  : 45.50\nOverall L1: 45.50\n",
        },
        {
          title = "Vectorization ratios",
          txt = "INT\nall    : 34%\nload   : 100%\nstore  : NA (no store vectorizable/vectorized instructions)\nmul    : NA (no mul vectorizable/vectorized instructions)\nadd-sub: NA (no add-sub vectorizable/vectorized instructions)\nfma    : NA (no fma vectorizable/vectorized instructions)\nother  : 0%\nFP\nall     : 64%\nload    : 69%\nstore   : 0%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : 75%\nfma     : 72%\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 72%\nINT+FP\nall     : 53%\nload    : 77%\nstore   : 0%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : 75%\nfma     : 72%\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 39%\n",
        },
        {
          title = "Vector efficiency ratios",
          txt = "INT\nall    : 40%\nload   : 93%\nstore  : NA (no store vectorizable/vectorized instructions)\nmul    : NA (no mul vectorizable/vectorized instructions)\nadd-sub: NA (no add-sub vectorizable/vectorized instructions)\nfma    : NA (no fma vectorizable/vectorized instructions)\nother  : 12%\nFP\nall     : 48%\nload    : 69%\nstore   : 12%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : 28%\nfma     : 71%\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 53%\nINT+FP\nall     : 45%\nload    : 75%\nstore   : 12%\nmul     : NA (no mul vectorizable/vectorized instructions)\nadd-sub : 28%\nfma     : 71%\ndiv/sqrt: NA (no div/sqrt vectorizable/vectorized instructions)\nother   : 34%\n",
        },
        {
          title = "Cycles and memory resources usage",
          txt = "Assuming all data fit into the L1 cache, each iteration of the binary loop takes 45.50 cycles. At this rate:\n - 26% of peak load performance is reached (34.29 out of 128.00 bytes loaded per cycle (GB/s @ 1GHz))\n - 0% of peak store performance is reached (0.18 out of 64.00 bytes stored per cycle (GB/s @ 1GHz))\n",
        },
        {
          title = "Front-end bottlenecks",
          txt = "Found no such bottlenecks.",
        },
        {
          title = "ASM code",
          txt = "In the binary file, the address of the loop is: 5a21f0\n\nInstruction                                                   | Nb FU | P0   | P1   | P2   | P3   | P4 | P5   | P6   | P7   | Latency | Recip. throughput\n---------------------------------------------------------------------------------------------------------------------------------------------------------\nMOV 0x28(%RSP),%RAX                                           | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV (%R8,%R12,8),%RDX                                         | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nMOV 0x8(%R8,%R12,8),%R11                                      | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nVMOVSD (%RAX,%R12,8),%XMM2                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nCMP %R11,%RDX                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJGE 5a251f <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x246f> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %R11,%RSI                                                 | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nMOV %RDX,%R15                                                 | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nSUB %RDX,%RSI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nLEA -0x1(%RSI),%RCX                                           | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nCMP $0x6,%RCX                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJBE 5a2c1b <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2b6b> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV %RSI,%R10                                                 | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nLEA (,%RDX,8),%RCX                                            | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVXORPD %XMM0,%XMM0,%XMM0                                      | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nXOR %EAX,%EAX                                                 | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nSHR $0x3,%R10                                                 | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nLEA (%R14,%RCX,1),%R9                                         | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nADD %R13,%RCX                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nSAL $0x6,%R10                                                 | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nLEA -0x40(%R10),%RDI                                          | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nSHR $0x6,%RDI                                                 | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 1       | 0.50\nINC %RDI                                                      | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x7,%EDI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a235b <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x22ab>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x1,%RDI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a2335 <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2285>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x2,%RDI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a2318 <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2268>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x3,%RDI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a22fb <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x224b>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x4,%RDI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a22de <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x222e>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x5,%RDI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a22c1 <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2211>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nCMP $0x6,%RDI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a22a4 <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x21f4>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVMOVDQU64 (%RCX),%ZMM15                                       | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nKMOVB %K0,%K5                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nMOV $0x40,%EAX                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVGATHERQPD (%RBX,%ZMM15,8),%ZMM6{%K5}                         | 4     | 1    | 0    | 4    | 4    | 0  | 1    | 0    | 0    | 21      | 5\nVFMADD231PD (%R9),%ZMM6,%ZMM0                                 | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 4       | 0.50\nVMOVDQU64 (%RCX,%RAX,1),%ZMM7                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nKMOVB %K0,%K6                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nVGATHERQPD (%RBX,%ZMM7,8),%ZMM10{%K6}                         | 4     | 1    | 0    | 4    | 4    | 0  | 1    | 0    | 0    | 21      | 5\nVFMADD231PD (%R9,%RAX,1),%ZMM10,%ZMM0                         | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 4       | 0.50\nADD $0x40,%RAX                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVMOVDQU64 (%RCX,%RAX,1),%ZMM11                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nKMOVB %K0,%K3                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nVGATHERQPD (%RBX,%ZMM11,8),%ZMM12{%K3}                        | 4     | 1    | 0    | 4    | 4    | 0  | 1    | 0    | 0    | 21      | 5\nVFMADD231PD (%R9,%RAX,1),%ZMM12,%ZMM0                         | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 4       | 0.50\nADD $0x40,%RAX                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVMOVDQU64 (%RCX,%RAX,1),%ZMM4                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nKMOVB %K0,%K7                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nVGATHERQPD (%RBX,%ZMM4,8),%ZMM9{%K7}                          | 4     | 1    | 0    | 4    | 4    | 0  | 1    | 0    | 0    | 21      | 5\nVFMADD231PD (%R9,%RAX,1),%ZMM9,%ZMM0                          | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 4       | 0.50\nADD $0x40,%RAX                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVMOVDQU64 (%RCX,%RAX,1),%ZMM13                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nKMOVB %K0,%K4                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nVGATHERQPD (%RBX,%ZMM13,8),%ZMM3{%K4}                         | 4     | 1    | 0    | 4    | 4    | 0  | 1    | 0    | 0    | 21      | 5\nVFMADD231PD (%R9,%RAX,1),%ZMM3,%ZMM0                          | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 4       | 0.50\nADD $0x40,%RAX                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVMOVDQU64 (%RCX,%RAX,1),%ZMM5                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nKMOVB %K0,%K2                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nVGATHERQPD (%RBX,%ZMM5,8),%ZMM1{%K2}                          | 4     | 1    | 0    | 4    | 4    | 0  | 1    | 0    | 0    | 21      | 5\nVFMADD231PD (%R9,%RAX,1),%ZMM1,%ZMM0                          | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 4       | 0.50\nADD $0x40,%RAX                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVMOVDQU64 (%RCX,%RAX,1),%ZMM8                                 | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nKMOVB %K0,%K1                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nVGATHERQPD (%RBX,%ZMM8,8),%ZMM14{%K1}                         | 4     | 1    | 0    | 4    | 4    | 0  | 1    | 0    | 0    | 21      | 5\nVFMADD231PD (%R9,%RAX,1),%ZMM14,%ZMM0                         | 1     | 0.50 | 0    | 0.50 | 0.50 | 0  | 0.50 | 0    | 0    | 4       | 0.50\nADD $0x40,%RAX                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP %RAX,%R10                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a2440 <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2390>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVEXTRACTF64X4 $0x1,%ZMM0,%YMM15                               | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nMOV %RSI,%R9                                                  | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nVADDPD %YMM0,%YMM15,%YMM6                                     | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nAND $-0x8,%R9                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVADDPD %YMM15,%YMM0,%YMM14                                    | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nADD %R9,%RDX                                                  | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVEXTRACTF64X2 $0x1,%YMM6,%XMM7                                | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nVADDPD %XMM6,%XMM7,%XMM10                                     | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nVUNPCKHPD %XMM10,%XMM10,%XMM11                                | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVADDPD %XMM10,%XMM11,%XMM12                                   | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nVADDSD %XMM12,%XMM2,%XMM8                                     | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nTEST $0x7,%SIL                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJE 5a253d <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x248d>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nSUB %R9,%RSI                                                  | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nLEA -0x1(%RSI),%RCX                                           | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nCMP $0x2,%RCX                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJBE 5a2c6c <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2bbc> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nADD %R15,%R9                                                  | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nKMOVB %K0,%K6                                                 | 1     | 1    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 1       | 1\nMOV %RSI,%R15                                                 | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nVMOVDQU (%R13,%R9,8),%YMM4                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 5       | 0.50\nAND $-0x4,%R15                                                | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nADD %R15,%RDX                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nAND $0x3,%ESI                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVGATHERQPD (%RBX,%YMM4,8),%YMM9{%K6}                          | 4     | 1    | 0    | 2    | 2    | 0  | 1    | 0    | 0    | 20      | 4\nVFMADD231PD (%R14,%R9,8),%YMM9,%YMM14                         | 1     | 0.50 | 0.50 | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4       | 0.50\nVEXTRACTF64X2 $0x1,%YMM14,%XMM13                              | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 3       | 1\nVADDPD %XMM14,%XMM13,%XMM3                                    | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nVUNPCKHPD %XMM3,%XMM3,%XMM8                                   | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVADDPD %XMM3,%XMM8,%XMM5                                      | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nVADDSD %XMM5,%XMM2,%XMM2                                      | 1     | 0.50 | 0.50 | 0    | 0    | 0  | 0    | 0    | 0    | 4       | 0.50\nJE 5a251f <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x246f>  | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV (%R13,%RDX,8),%R9                                         | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nLEA 0x1(%RDX),%R10                                            | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nLEA (,%RDX,8),%RSI                                            | 1     | 0    | 0.50 | 0    | 0    | 0  | 0.50 | 0    | 0    | 1       | 0.50\nVMOVSD (%RBX,%R9,8),%XMM1                                     | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nVFMADD231SD (%R14,%RDX,8),%XMM1,%XMM2                         | 1     | 0.50 | 0.50 | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4       | 0.50\nCMP %R10,%R11                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJLE 5a251f <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x246f> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV 0x8(%R13,%RSI,1),%RDI                                     | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nADD $0x2,%RDX                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nVMOVSD (%RBX,%RDI,8),%XMM14                                   | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nVFMADD231SD 0x8(%R14,%RSI,1),%XMM14,%XMM2                     | 1     | 0.50 | 0.50 | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4       | 0.50\nCMP %R11,%RDX                                                 | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nJGE 5a251f <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x246f> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nMOV 0x10(%R13,%RSI,1),%RDX                                    | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nVMOVSD 0x10(%R14,%RSI,1),%XMM0                                | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nVFMADD231SD (%RBX,%RDX,8),%XMM0,%XMM2                         | 1     | 0.50 | 0.50 | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4       | 0.50\nMOV 0x30(%RSP),%R11                                           | 1     | 0    | 0    | 0.50 | 0.50 | 0  | 0    | 0    | 0    | 4-5     | 0.50\nVMOVSD %XMM2,(%R11,%R12,8)                                    | 1     | 0    | 0    | 0.33 | 0.33 | 1  | 0    | 0    | 0.33 | 3       | 1\nINC %R12                                                      | 1     | 0.25 | 0.25 | 0    | 0    | 0  | 0.25 | 0.25 | 0    | 1       | 0.25\nCMP %R12,0x38(%RSP)                                           | 1     | 0.25 | 0.25 | 0.50 | 0.50 | 0  | 0.25 | 0.25 | 0    | 1       | 0.50\nJNE 5a21f0 <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2140> | 1     | 0.50 | 0    | 0    | 0    | 0  | 0    | 0.50 | 0    | 0       | 0.50-1\nVMOVSD %XMM8,%XMM8,%XMM2                                      | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nJMP 5a251f <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x246f> | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 1    | 0    | 0       | 1-2\nVMOVSD %XMM2,%XMM2,%XMM8                                      | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nVXORPD %XMM14,%XMM14,%XMM14                                   | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nXOR %R9D,%R9D                                                 | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 0    | 0    | 0       | 0.25\nJMP 5a247e <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x23ce> | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 1    | 0    | 0       | 1-2\nVMOVSD %XMM8,%XMM8,%XMM2                                      | 1     | 0    | 0    | 0    | 0    | 0  | 1    | 0    | 0    | 1       | 1\nJMP 5a24d1 <hypre_CSRMatrixMatvecOutOfPlace._omp_fn.6+0x2421> | 1     | 0    | 0    | 0    | 0    | 0  | 0    | 1    | 0    | 0       | 1-2\n",
        },
      },
      header = {
        "9% of peak computational performance is used (3.16 out of 32.00 FLOP per cycle (GFLOPS @ 1GHz))",
      },
      brief = {
      },
      gain = {
        {
          workaround = " - Try to reorganize arrays of structures to structures of arrays\n - Consider to permute loops (see vectorization gain report)\n",
          title = "Code clean check",
          txt = "Detected a slowdown caused by scalar integer instructions (typically used for address computation).\nBy removing them, you can lower the cost of an iteration from 45.50 to 42.00 cycles (1.08x speedup).",
        },
        {
          workaround = " - Try another compiler or update/tune your current one\n - Remove inter-iterations dependences from your loop and make it unit-stride:\n  * If your arrays have 2 or more dimensions, check whether elements are accessed contiguously and, otherwise, try to permute loops accordingly:\nC storage order is row-major: for(i) for(j) a[j][i] = b[j][i]; (slow, non stride 1) => for(i) for(j) a[i][j] = b[i][j]; (fast, stride 1)\n  * If your loop streams arrays of structures (AoS), try to use structures of arrays instead (SoA):\nfor(i) a[i].x = b[i].x; (slow, non stride 1) => for(i) a.x[i] = b.x[i]; (fast, stride 1)\n",
          details = "53% of SSE/AVX instructions are used in vector version (process two or more data elements in vector registers):\n - 77% of SSE/AVX loads are used in vector version.\n - 0% of SSE/AVX stores are used in vector version.\n - 75% of SSE/AVX addition or subtraction instructions are used in vector version.\n - 72% of SSE/AVX fused multiply-add instructions are used in vector version.\n - 39% of SSE/AVX instructions that are not load, store, addition, subtraction nor multiply instructions are used in vector version.\nSince your execution units are vector units, only a fully vectorized loop can use their full power.\n",
          title = "Vectorization",
          txt = "Your loop is partially vectorized.\nOnly 45% of vector register length is used (average across all SSE/AVX instructions).\nBy fully vectorizing your loop, you can lower the cost of an iteration from 45.50 to 40.94 cycles (1.11x speedup).",
        },
        {
          workaround = " - Read less array elements\n - Write less array elements\n - Provide more information to your compiler:\n  * hardcode the bounds of the corresponding 'for' loop\n  * use the 'restrict' C99 keyword\n",
          title = "Execution units bottlenecks",
          txt = "Performance is limited by:\n - reading data from caches/RAM (load units are a bottleneck)\n - writing data to caches/RAM (the store unit is a bottleneck)\n\nBy removing all these bottlenecks, you can lower the cost of an iteration from 45.50 to 42.25 cycles (1.08x speedup).\n",
        },
      },
      potential = {
        {
          title = "FMA",
          txt = "Detected 63 FMA (fused multiply-add) operations.",
        },
      },
    },
  common = {
    header = {
      "The loop is defined in /home/kcamus/qaas_runs/169-443-9681/intel/AMG/build/AMG/AMG/seq_mv/csr_matvec.c:334-341.\n",
      "Warnings:\n - Non-innermost loop: analyzing only self part (ignoring child loops).\n - Ignoring paths for analysis\n - Too many paths. If you really need to analyze all of the 128 paths individually, rerun with max-paths=128\n - RecMII not computed since number of paths is unknown or > max_paths\n - Streams not analyzed since number of paths is unknown or > max_paths\n",
      "Try to simplify control and/or increase the maximum number of paths per function/loop through the 'max-paths-nb' option.\n",
      "This loop has 128 execution paths.\n",
      "The presence of multiple execution paths is typically the main/first bottleneck.\nTry to simplify control inside loop: ideally, try to remove all conditional expressions, for example by (if applicable):\n - hoisting them (moving them outside the loop)\n - turning them into conditional moves, MIN or MAX\n\n",
      "Ex: if (x<0) x=0 => x = (x<0 ? 0 : x) (or MAX(0,x) after defining the corresponding macro)\n",
    },
    nb_paths = 128,
  },
}
