_cqa_text_report = {
  paths = {
    {
      hint = {
        {
          workaround = "<ul><li>Try to reorganize arrays of structures to structures of arrays</li><li>Consider to permute loops (see vectorization gain report)</li></ul>",
          details = "<ul><li>Constant non-unit stride: 1 occurrence(s)</li></ul>Non-unit stride (uncontiguous) accesses are not efficiently using data caches\n",
          title = "Slow data structures access",
          txt = "Detected data structures (typically arrays) that cannot be efficiently read/written",
        },
        {
          title = "Type of elements and instruction set",
          txt = "",
        },
        {
          title = "Matching between your loop (in the source code) and the binary loop",
          txt = "The binary loop does not contain any FP arithmetical operations.\nThe binary loop is loading 1024 bytes.",
        },
        {
          workaround = "Unroll your loop if trip count is significantly higher than target unroll factor and if some data references are common to consecutive iterations. This can be done manually. Or by recompiling with -funroll-loops and/or -floop-unroll-and-jam.",
          title = "Unroll opportunity",
          txt = "Loop is data access bound.",
        },
      },
      expert = {
        {
          title = "General properties",
          txt = "<table><tr><td>nb instructions</td><td>43</td></tr><tr><td>nb uops</td><td>34</td></tr><tr><td>loop length</td><td>304</td></tr><tr><td>used x86 registers</td><td>2</td></tr><tr><td>used mmx registers</td><td>0</td></tr><tr><td>used xmm registers</td><td>0</td></tr><tr><td>used ymm registers</td><td>0</td></tr><tr><td>used zmm registers</td><td>16</td></tr><tr><td>nb stack references</td><td>0</td></tr></table>",
        },
        {
          title = "Front-end",
          txt = "ASSUMED MACRO FUSION\nFIT IN UOP CACHE\n<table><tr><td>micro-operation queue</td><td>8.50 cycles</td></tr><tr><td>front end</td><td>8.50 cycles</td></tr></table>",
        },
        {
          title = "Back-end",
          txt = "<table><tr><th>      </th><th>P0</th><th>P1</th><th>P2</th><th>P3</th><th>P4</th><th>P5</th><th>P6</th><th>P7</th></tr><tr><td>uops</td><td>8.00</td><td>1.00</td><td>8.00</td><td>8.00</td><td>0.00</td><td>8.00</td><td>1.00</td><td>0.00</td></tr><tr><td>cycles</td><td>8.00</td><td>1.00</td><td>8.00</td><td>8.00</td><td>0.00</td><td>8.00</td><td>1.00</td><td>0.00</td></tr></table>\n<table><tr><td>Cycles executing div or sqrt instructions</td><td>NA</td></tr><tr><td>Longest recurrence chain latency (RecMII)</td><td>8.00</td></tr></table>",
        },
        {
          title = "Front-end and detailed OoO resources (UFS)",
          txt = "<table><tr><td>FE+BE cycles</td><td>8.63</td></tr><tr><td>Stall cycles</td><td>0.00</td></tr></table>",
        },
        {
          title = "Cycles summary",
          txt = "<table><tr><td>Front-end</td><td>8.50</td></tr><tr><td>Dispatch</td><td>8.00</td></tr><tr><td>Data deps.</td><td>8.00</td></tr><tr><td>Overall L1</td><td>8.50</td></tr></table>",
        },
        {
          title = "Vectorization ratios",
          txt = "<table><tr><td>all</td><td>100%</td></tr><tr><td>load</td><td>100%</td></tr><tr><td>store</td><td>NA (no store vectorizable/vectorized instructions)</td></tr><tr><td>mul</td><td>NA (no mul vectorizable/vectorized instructions)</td></tr><tr><td>add-sub</td><td>100%</td></tr><tr><td>fma</td><td>NA (no fma vectorizable/vectorized instructions)</td></tr><tr><td>div/sqrt</td><td>NA (no div/sqrt vectorizable/vectorized instructions)</td></tr><tr><td>other</td><td>100%</td></tr></table>",
        },
        {
          title = "Vector efficiency ratios",
          txt = "<table><tr><td>all</td><td>100%</td></tr><tr><td>load</td><td>100%</td></tr><tr><td>store</td><td>NA (no store vectorizable/vectorized instructions)</td></tr><tr><td>mul</td><td>NA (no mul vectorizable/vectorized instructions)</td></tr><tr><td>add-sub</td><td>100%</td></tr><tr><td>fma</td><td>NA (no fma vectorizable/vectorized instructions)</td></tr><tr><td>div/sqrt</td><td>NA (no div/sqrt vectorizable/vectorized instructions)</td></tr><tr><td>other</td><td>100%</td></tr></table>",
        },
        {
          title = "Cycles and memory resources usage",
          txt = "Detected masked instructions: assuming all mask elements are active.\nAssuming all data fit into the L1 cache, each iteration of the binary loop takes 8.50 cycles. At this rate:\n<ul><li>94% of peak load performance is reached (120.47 out of 128.00 bytes loaded per cycle (GB/s @ 1GHz))</li></ul>",
        },
        {
          title = "Front-end bottlenecks",
          txt = "Performance is limited by instruction throughput (loading/decoding program instructions to execution core) (front-end is a bottleneck).\n\nBy removing all these bottlenecks, you can lower the cost of an iteration from 8.50 to 8.00 cycles (1.06x speedup).\n",
        },
        {
          title = "ASM code",
          txt = "In the binary file, the address of the loop is: 59a343\n\n<table><tr><th>Instruction</th><th>Nb FU</th><th>P0</th><th>P1</th><th>P2</th><th>P3</th><th>P4</th><th>P5</th><th>P6</th><th>P7</th><th>Latency</th><th>Recip. throughput</th></tr><tr><td>VMOVDQU64 0x8(%R8),%ZMM11</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>VMOVDQU64 0x48(%R8),%ZMM15</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>ADD $0x200,%R8</td><td>1</td><td>0.25</td><td>0.25</td><td>0</td><td>0</td><td>0</td><td>0.25</td><td>0.25</td><td>0</td><td>1</td><td>0.25</td></tr><tr><td>VMOVDQU64 -0x178(%R8),%ZMM6</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>VMOVDQU64 -0x138(%R8),%ZMM10</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>VPSUBQ -0x200(%R8),%ZMM11,%ZMM12</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPSUBQ -0x1c0(%R8),%ZMM15,%ZMM5</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPSUBQ -0x180(%R8),%ZMM6,%ZMM7</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM12,%K1</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM5,%K2</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM7,%K3</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM13{%K1}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM3{%K2}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VPSUBQ %ZMM13,%ZMM0,%ZMM14</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPSUBQ -0x140(%R8),%ZMM10,%ZMM0</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VMOVDQU64 -0xf8(%R8),%ZMM13</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM8{%K3}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VPSUBQ %ZMM3,%ZMM14,%ZMM4</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VMOVDQU64 -0xb8(%R8),%ZMM3</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>VPSUBQ -0x100(%R8),%ZMM13,%ZMM14</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM0,%K4</td></tr><tr><td>VPSUBQ %ZMM8,%ZMM4,%ZMM9</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VMOVDQU64 -0x78(%R8),%ZMM8</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>VPSUBQ -0xc0(%R8),%ZMM3,%ZMM4</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM14,%K5</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM11{%K4}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM4,%K6</td></tr><tr><td>VPSUBQ %ZMM11,%ZMM9,%ZMM12</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VMOVDQU64 -0x38(%R8),%ZMM11</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>VPSUBQ -0x80(%R8),%ZMM8,%ZMM9</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM15{%K5}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VPSUBQ %ZMM15,%ZMM12,%ZMM5</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPSUBQ -0x40(%R8),%ZMM11,%ZMM12</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM9,%K7</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM6{%K6}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM12,%K1</td></tr><tr><td>VPSUBQ %ZMM6,%ZMM5,%ZMM7</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM10{%K7}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VPSUBQ %ZMM10,%ZMM7,%ZMM0</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM13{%K1}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VPSUBQ %ZMM13,%ZMM0,%ZMM0</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>CMP %R8,%RSI</td><td>1</td><td>0.25</td><td>0.25</td><td>0</td><td>0</td><td>0</td><td>0.25</td><td>0.25</td><td>0</td><td>1</td><td>0.25</td></tr><tr><td>JNE 59a343 <hypre_CSRMatrixSetRownnz+0x193></td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>0.50-1</td></tr></table>",
        },
      },
      header = {
        "Warnings:\n<ul><li>The number of fused uops of the instruction [VPCMPNLEQ	%ZMM2,%ZMM12,%K1] is unknown</li><li>The number of fused uops of the instruction [VPCMPNLEQ	%ZMM2,%ZMM5,%K2] is unknown</li><li>The number of fused uops of the instruction [VPCMPNLEQ	%ZMM2,%ZMM7,%K3] is unknown</li><li>The number of fused uops of the instruction [VPCMPNLEQ	%ZMM2,%ZMM0,%K4] is unknown</li><li>The number of fused uops of the instruction [VPCMPNLEQ	%ZMM2,%ZMM14,%K5] is unknown</li><li>The number of fused uops of the instruction [VPCMPNLEQ	%ZMM2,%ZMM4,%K6] is unknown</li><li>The number of fused uops of the instruction [VPCMPNLEQ	%ZMM2,%ZMM9,%K7] is unknown</li></ul>",
        "0% of peak computational performance is used (0.00 out of 64.00 FLOP per cycle (GFLOPS @ 1GHz))",
      },
      brief = {
      },
      gain = {
        {
          details = "All SSE/AVX instructions are used in vector version (process two or more data elements in vector registers).\n",
          title = "Vectorization",
          txt = "Your loop is fully vectorized, using full register length.\n",
        },
        {
          title = "Execution units bottlenecks",
          txt = "Found no such bottlenecks but see expert reports for more complex bottlenecks.",
        },
      },
      potential = {
        {
          workaround = "If your loop is irregular, try to remove or hoist conditional structures out of your loop. If it mixes elements of different sizes, try to uniformize them.",
          details = "Vector registers are partially exploited, which is expected if your loop is irregular or mixes elements of different sizes.",
          title = "Masked instructions",
          txt = "Detected masked instructions.",
        },
      },
    },
  },
  AVG = {
      hint = {
        {
          workaround = "<ul><li>Try to reorganize arrays of structures to structures of arrays</li><li>Consider to permute loops (see vectorization gain report)</li></ul>",
          details = "<ul><li>Constant non-unit stride: 1 occurrence(s)</li></ul>Non-unit stride (uncontiguous) accesses are not efficiently using data caches\n",
          title = "Slow data structures access",
          txt = "Detected data structures (typically arrays) that cannot be efficiently read/written",
        },
        {
          title = "Type of elements and instruction set",
          txt = "",
        },
        {
          title = "Matching between your loop (in the source code) and the binary loop",
          txt = "The binary loop does not contain any FP arithmetical operations.\nThe binary loop is loading 1024 bytes.",
        },
        {
          workaround = "Unroll your loop if trip count is significantly higher than target unroll factor and if some data references are common to consecutive iterations. This can be done manually. Or by recompiling with -funroll-loops and/or -floop-unroll-and-jam.",
          title = "Unroll opportunity",
          txt = "Loop is data access bound.",
        },
      },
      expert = {
        {
          title = "General properties",
          txt = "<table><tr><td>nb instructions</td><td>43</td></tr><tr><td>nb uops</td><td>34</td></tr><tr><td>loop length</td><td>304</td></tr><tr><td>used x86 registers</td><td>2</td></tr><tr><td>used mmx registers</td><td>0</td></tr><tr><td>used xmm registers</td><td>0</td></tr><tr><td>used ymm registers</td><td>0</td></tr><tr><td>used zmm registers</td><td>16</td></tr><tr><td>nb stack references</td><td>0</td></tr></table>",
        },
        {
          title = "Front-end",
          txt = "ASSUMED MACRO FUSION\nFIT IN UOP CACHE\n<table><tr><td>micro-operation queue</td><td>8.50 cycles</td></tr><tr><td>front end</td><td>8.50 cycles</td></tr></table>",
        },
        {
          title = "Back-end",
          txt = "<table><tr><th>      </th><th>P0</th><th>P1</th><th>P2</th><th>P3</th><th>P4</th><th>P5</th><th>P6</th><th>P7</th></tr><tr><td>uops</td><td>8.00</td><td>1.00</td><td>8.00</td><td>8.00</td><td>0.00</td><td>8.00</td><td>1.00</td><td>0.00</td></tr><tr><td>cycles</td><td>8.00</td><td>1.00</td><td>8.00</td><td>8.00</td><td>0.00</td><td>8.00</td><td>1.00</td><td>0.00</td></tr></table>\n<table><tr><td>Cycles executing div or sqrt instructions</td><td>NA</td></tr><tr><td>Longest recurrence chain latency (RecMII)</td><td>8.00</td></tr></table>",
        },
        {
          title = "Front-end and detailed OoO resources (UFS)",
          txt = "<table><tr><td>FE+BE cycles</td><td>8.63</td></tr><tr><td>Stall cycles</td><td>0.00</td></tr></table>",
        },
        {
          title = "Cycles summary",
          txt = "<table><tr><td>Front-end</td><td>8.50</td></tr><tr><td>Dispatch</td><td>8.00</td></tr><tr><td>Data deps.</td><td>8.00</td></tr><tr><td>Overall L1</td><td>8.50</td></tr></table>",
        },
        {
          title = "Vectorization ratios",
          txt = "<table><tr><td>all</td><td>100%</td></tr><tr><td>load</td><td>100%</td></tr><tr><td>store</td><td>NA (no store vectorizable/vectorized instructions)</td></tr><tr><td>mul</td><td>NA (no mul vectorizable/vectorized instructions)</td></tr><tr><td>add-sub</td><td>100%</td></tr><tr><td>fma</td><td>NA (no fma vectorizable/vectorized instructions)</td></tr><tr><td>div/sqrt</td><td>NA (no div/sqrt vectorizable/vectorized instructions)</td></tr><tr><td>other</td><td>100%</td></tr></table>",
        },
        {
          title = "Vector efficiency ratios",
          txt = "<table><tr><td>all</td><td>100%</td></tr><tr><td>load</td><td>100%</td></tr><tr><td>store</td><td>NA (no store vectorizable/vectorized instructions)</td></tr><tr><td>mul</td><td>NA (no mul vectorizable/vectorized instructions)</td></tr><tr><td>add-sub</td><td>100%</td></tr><tr><td>fma</td><td>NA (no fma vectorizable/vectorized instructions)</td></tr><tr><td>div/sqrt</td><td>NA (no div/sqrt vectorizable/vectorized instructions)</td></tr><tr><td>other</td><td>100%</td></tr></table>",
        },
        {
          title = "Cycles and memory resources usage",
          txt = "Detected masked instructions: assuming all mask elements are active.\nAssuming all data fit into the L1 cache, each iteration of the binary loop takes 8.50 cycles. At this rate:\n<ul><li>94% of peak load performance is reached (120.47 out of 128.00 bytes loaded per cycle (GB/s @ 1GHz))</li></ul>",
        },
        {
          title = "Front-end bottlenecks",
          txt = "Performance is limited by instruction throughput (loading/decoding program instructions to execution core) (front-end is a bottleneck).\n\nBy removing all these bottlenecks, you can lower the cost of an iteration from 8.50 to 8.00 cycles (1.06x speedup).\n",
        },
        {
          title = "ASM code",
          txt = "In the binary file, the address of the loop is: 59a343\n\n<table><tr><th>Instruction</th><th>Nb FU</th><th>P0</th><th>P1</th><th>P2</th><th>P3</th><th>P4</th><th>P5</th><th>P6</th><th>P7</th><th>Latency</th><th>Recip. throughput</th></tr><tr><td>VMOVDQU64 0x8(%R8),%ZMM11</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>VMOVDQU64 0x48(%R8),%ZMM15</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>ADD $0x200,%R8</td><td>1</td><td>0.25</td><td>0.25</td><td>0</td><td>0</td><td>0</td><td>0.25</td><td>0.25</td><td>0</td><td>1</td><td>0.25</td></tr><tr><td>VMOVDQU64 -0x178(%R8),%ZMM6</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>VMOVDQU64 -0x138(%R8),%ZMM10</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>VPSUBQ -0x200(%R8),%ZMM11,%ZMM12</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPSUBQ -0x1c0(%R8),%ZMM15,%ZMM5</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPSUBQ -0x180(%R8),%ZMM6,%ZMM7</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM12,%K1</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM5,%K2</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM7,%K3</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM13{%K1}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM3{%K2}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VPSUBQ %ZMM13,%ZMM0,%ZMM14</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPSUBQ -0x140(%R8),%ZMM10,%ZMM0</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VMOVDQU64 -0xf8(%R8),%ZMM13</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM8{%K3}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VPSUBQ %ZMM3,%ZMM14,%ZMM4</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VMOVDQU64 -0xb8(%R8),%ZMM3</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>VPSUBQ -0x100(%R8),%ZMM13,%ZMM14</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM0,%K4</td></tr><tr><td>VPSUBQ %ZMM8,%ZMM4,%ZMM9</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VMOVDQU64 -0x78(%R8),%ZMM8</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>VPSUBQ -0xc0(%R8),%ZMM3,%ZMM4</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM14,%K5</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM11{%K4}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM4,%K6</td></tr><tr><td>VPSUBQ %ZMM11,%ZMM9,%ZMM12</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VMOVDQU64 -0x38(%R8),%ZMM11</td><td>1</td><td>0</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>5</td><td>0.50</td></tr><tr><td>VPSUBQ -0x80(%R8),%ZMM8,%ZMM9</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM15{%K5}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VPSUBQ %ZMM15,%ZMM12,%ZMM5</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPSUBQ -0x40(%R8),%ZMM11,%ZMM12</td><td>1</td><td>0.50</td><td>0</td><td>0.50</td><td>0.50</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM9,%K7</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM6{%K6}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VPCMPNLEQ %ZMM2,%ZMM12,%K1</td></tr><tr><td>VPSUBQ %ZMM6,%ZMM5,%ZMM7</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM10{%K7}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VPSUBQ %ZMM10,%ZMM7,%ZMM0</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>VMOVDQA64 %ZMM1,%ZMM13{%K1}{z}</td><td>1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.25</td></tr><tr><td>VPSUBQ %ZMM13,%ZMM0,%ZMM0</td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>1</td><td>0.50</td></tr><tr><td>CMP %R8,%RSI</td><td>1</td><td>0.25</td><td>0.25</td><td>0</td><td>0</td><td>0</td><td>0.25</td><td>0.25</td><td>0</td><td>1</td><td>0.25</td></tr><tr><td>JNE 59a343 <hypre_CSRMatrixSetRownnz+0x193></td><td>1</td><td>0.50</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0.50</td><td>0</td><td>0</td><td>0.50-1</td></tr></table>",
        },
      },
      header = {
        "Warnings:\n<ul><li>The number of fused uops of the instruction [VPCMPNLEQ	%ZMM2,%ZMM12,%K1] is unknown</li><li>The number of fused uops of the instruction [VPCMPNLEQ	%ZMM2,%ZMM5,%K2] is unknown</li><li>The number of fused uops of the instruction [VPCMPNLEQ	%ZMM2,%ZMM7,%K3] is unknown</li><li>The number of fused uops of the instruction [VPCMPNLEQ	%ZMM2,%ZMM0,%K4] is unknown</li><li>The number of fused uops of the instruction [VPCMPNLEQ	%ZMM2,%ZMM14,%K5] is unknown</li><li>The number of fused uops of the instruction [VPCMPNLEQ	%ZMM2,%ZMM4,%K6] is unknown</li><li>The number of fused uops of the instruction [VPCMPNLEQ	%ZMM2,%ZMM9,%K7] is unknown</li></ul>",
        "0% of peak computational performance is used (0.00 out of 64.00 FLOP per cycle (GFLOPS @ 1GHz))",
      },
      brief = {
      },
      gain = {
        {
          details = "All SSE/AVX instructions are used in vector version (process two or more data elements in vector registers).\n",
          title = "Vectorization",
          txt = "Your loop is fully vectorized, using full register length.\n",
        },
        {
          title = "Execution units bottlenecks",
          txt = "Found no such bottlenecks but see expert reports for more complex bottlenecks.",
        },
      },
      potential = {
        {
          workaround = "If your loop is irregular, try to remove or hoist conditional structures out of your loop. If it mixes elements of different sizes, try to uniformize them.",
          details = "Vector registers are partially exploited, which is expected if your loop is irregular or mixes elements of different sizes.",
          title = "Masked instructions",
          txt = "Detected masked instructions.",
        },
      },
    },
  common = {
    header = {
      "The loop is defined in /home/kcamus/qaas_runs/169-443-9681/intel/AMG/build/AMG/AMG/seq_mv/csr_matrix.c:145-148.\n",
      "The related source loop is not unrolled or unrolled with no peel/tail loop.",
    },
    nb_paths = 1,
  },
}
